/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.ChangeSetAuthorFilter;
import com.datical.liquibase.ext.changelog.filter.ChangeSetIdFilter;
import com.datical.liquibase.ext.changelog.filter.ChangeSetPathFilter;
import com.datical.liquibase.ext.changelog.filter.ProDbmsChangeSetFilter;
import com.datical.liquibase.ext.command.SetContextsCommandStep;
import com.datical.liquibase.ext.command.SetLabelsCommandStep;
import java.util.ArrayList;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;

public abstract class AbstractSetCommandStep
extends AbstractCommandStep {
    public static final String DATABASE_TYPE_NAME = "database.typeName";
    private DbUrlConnectionCommandStep connectionCommandStep = null;

    public static void validateDbmsString(String dbmsString) {
        ArrayList databases = new ArrayList(Scope.getCurrentScope().getServiceLocator().findInstances(Database.class));
        boolean matches = databases.stream().anyMatch(db -> db.getShortName().equalsIgnoreCase(dbmsString));
        if (!matches) {
            throw new IllegalArgumentException("Database name '" + dbmsString + "' does not match any supported database.");
        }
    }

    protected ChangeLogIterator createCommandRunIterator(String changeSetId, String changeSetAuthor, String changeSetPath, DatabaseChangeLog changeLog, List<ChangeSetFilter> standardFilters) {
        ArrayList<ChangeSetFilter> commandFilters = new ArrayList<ChangeSetFilter>(standardFilters);
        if (changeSetId != null) {
            commandFilters.add(new ChangeSetIdFilter(changeSetId));
        }
        if (changeSetAuthor != null) {
            commandFilters.add(new ChangeSetAuthorFilter(changeSetAuthor));
        }
        if (changeSetPath != null) {
            commandFilters.add(new ChangeSetPathFilter(changeSetPath));
        }
        return new ChangeLogIterator(changeLog, commandFilters);
    }

    protected DatabaseChangeLog parseDatabaseChangelog(String changelogFile, String dbms, Database database) throws LiquibaseException {
        DatabaseChangeLog databaseChangeLog = null;
        if (changelogFile != null) {
            ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(changelogFile, Scope.getCurrentScope().getResourceAccessor());
            ChangeLogParameters changelogParameters = this.createChangeLogParameters(dbms, database);
            try {
                databaseChangeLog = parser.parse(changelogFile, changelogParameters, Scope.getCurrentScope().getResourceAccessor());
            }
            catch (ChangeLogParseException cpe) {
                String errorMessage = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", changelogFile, cpe.getMessage());
                Scope.getCurrentScope().getLog(SetLabelsCommandStep.class).severe(errorMessage);
                Scope.getCurrentScope().getUI().sendMessage(errorMessage);
                return null;
            }
        }
        return databaseChangeLog;
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter()});
    }

    protected ChangeLogIterator getStandardChangelogIterator(String dbms, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new ProDbmsChangeSetFilter(dbms)});
    }

    protected String getChangelogFileArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
    }

    protected String getContextsArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(SetLabelsCommandStep.CONTEXTS_ARG);
    }

    protected String getLabelFilterArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(SetLabelsCommandStep.LABEL_FILTER_ARG);
    }

    protected ChangeLogIterator createRunChangeLogIterator(CommandScope commandScope, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws DatabaseException {
        ChangeLogIterator standardRunChangeLogIterator = this.getStandardChangelogIterator(contexts, labelExpression, databaseChangeLog);
        List standardFilters = standardRunChangeLogIterator.getChangeSetFilters();
        return this.createCommandRunIterator((String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_ID_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_AUTHOR_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_PATH_ARG), databaseChangeLog, standardFilters);
    }

    protected ChangeLogIterator createRunChangeLogIterator(CommandScope commandScope, String dbms, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws DatabaseException {
        ChangeLogIterator standardRunChangeLogIterator = this.getStandardChangelogIterator(dbms, contexts, labelExpression, databaseChangeLog);
        List standardFilters = standardRunChangeLogIterator.getChangeSetFilters();
        return this.createCommandRunIterator((String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_ID_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_AUTHOR_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_PATH_ARG), databaseChangeLog, standardFilters);
    }

    private ChangeLogParameters createChangeLogParameters(String dbms, Database database) {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        if (dbms != null) {
            changeLogParameters.set(DATABASE_TYPE_NAME, (Object)dbms);
        } else if (database != null) {
            changeLogParameters.set(DATABASE_TYPE_NAME, (Object)database.getShortName());
        }
        return changeLogParameters;
    }

    protected Database obtainDatabase(String dbms, CommandScope commandScope) throws DatabaseException {
        Database database;
        Database database2 = database = dbms != null ? DatabaseFactory.getInstance().getDatabase(dbms) : null;
        if (database == null && commandScope.getArgumentValue(SetLabelsCommandStep.URL_ARG) != null) {
            this.connectionCommandStep = new DbUrlConnectionCommandStep();
            database = this.connectionCommandStep.obtainDatabase(commandScope);
        }
        return database;
    }

    protected void cleanUp(CommandResultsBuilder resultsBuilder) {
        if (this.connectionCommandStep != null) {
            this.connectionCommandStep.cleanUp(resultsBuilder);
        }
    }

    protected ChangeLogIterator determineChangeLogIterator(CommandScope commandScope, String dbms, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws DatabaseException {
        ChangeLogIterator runChangeLogIterator = dbms != null ? this.createRunChangeLogIterator(commandScope, dbms, contexts, labelExpression, databaseChangeLog) : (database != null ? this.createRunChangeLogIterator(commandScope, database.getShortName(), contexts, labelExpression, databaseChangeLog) : this.createRunChangeLogIterator(commandScope, contexts, labelExpression, databaseChangeLog));
        return runChangeLogIterator;
    }
}

