/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.arguments.DriftDetectionArguments;
import com.datical.liquibase.ext.command.InternalFormattedDiffCommandStep;
import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportFormat;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.reports.drift.DriftReport;
import com.datical.liquibase.ext.reports.drift.DriftReportParameters;
import com.datical.liquibase.ext.reports.drift.ReportObjectContainer;
import com.datical.liquibase.ext.reports.drift.TextDriftReport;
import com.datical.liquibase.ext.reports.drift.UnifiedDiffUtil;
import com.datical.liquibase.ext.reports.drift.parameters.DiffInfo;
import com.datical.liquibase.ext.reports.drift.parameters.DriftReportDatabaseInfo;
import com.datical.liquibase.ext.reports.drift.parameters.ReportInfo;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import java.awt.Desktop;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffChangelogCommandStep;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.DiffOutputControlCommandStep;
import liquibase.command.core.helpers.PreCompareCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.command.providers.ReferenceDatabase;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.LiquibaseUtil;
import liquibase.util.NetUtil;
import liquibase.util.StringUtil;

public class DriftReportCommandStep
extends AbstractCommandStep {
    public static String[] COMMAND_NAME = new String[]{"driftReport"};
    public static final CommandArgumentDefinition<Boolean> OPEN_REPORT;
    private static final List<String> DEFAULT_REPORT_NAMES;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffResult.class, FormattedDiffModel.class, Database.class, ReferenceDatabase.class, VisibleReportCommandArguments.class, DriftDetectionArguments.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (Arrays.equals(commandDefinition.getName(), COMMAND_NAME)) {
            commandDefinition.setHidden(true);
        }
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
        Boolean enabled = reportArguments.getEnabled();
        if (!enabled.booleanValue()) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        String path = reportArguments.getPath();
        ReportFormat format = reportArguments.getFormat();
        Boolean openInBrowser = (Boolean)commandScope.getArgumentValue(OPEN_REPORT);
        String name = reportArguments.getName();
        LocalDateTime timeNow = LocalDateTime.now();
        if (DEFAULT_REPORT_NAMES.contains(name)) {
            name = String.format("Drift-report-%s", reportArguments.buildReportDateFormat(timeNow));
        }
        Scope.getCurrentScope().getUI().sendMessage("Generating drift report...");
        Database database = (Database)commandScope.getDependency(Database.class);
        Database referenceDatabase = (Database)commandScope.getDependency(ReferenceDatabase.class);
        DiffResult diffResult = (DiffResult)resultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        String hostName = NetUtil.getLocalHostName();
        String localUser = EnvironmentUtils.getSystemUsername();
        Integer driftError = (Integer)resultsBuilder.getResult("driftExitCode");
        DriftDetectionArguments driftDetectionArguments = (DriftDetectionArguments)commandScope.getDependency(DriftDetectionArguments.class);
        boolean shouldReportDriftError = driftError != null && driftError != 0;
        TextDriftReport textDriftReport = new TextDriftReport(diffResult);
        List<ReportObjectContainer> missing = textDriftReport.getMissing();
        List<ReportObjectContainer> unexpected = textDriftReport.getUnexpected();
        List<ReportObjectContainer> changed = textDriftReport.getChanged();
        int numberMissing = diffResult.getMissingObjects().size();
        int numberUnexpected = diffResult.getUnexpectedObjects().size();
        int numberChanged = diffResult.getChangedObjects().size();
        FormattedDiffModel jsonMissingDiff = (FormattedDiffModel)((Object)commandScope.getDependency(FormattedDiffModel.class));
        if (jsonMissingDiff == null) {
            jsonMissingDiff = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        }
        FormattedDiffModel jsonUnexpectedDiff = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        FormattedDiffModel jsonChangedDiff = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        jsonMissingDiff.databases = null;
        jsonMissingDiff.unexpectedObjects = null;
        jsonMissingDiff.changedObjects = null;
        jsonUnexpectedDiff.databases = null;
        jsonUnexpectedDiff.missingObjects = null;
        jsonUnexpectedDiff.changedObjects = null;
        jsonChangedDiff.databases = null;
        jsonChangedDiff.missingObjects = null;
        jsonChangedDiff.unexpectedObjects = null;
        String jsonMissing = InternalFormattedDiffCommandStep.serialize(jsonMissingDiff);
        String jsonUnexpected = InternalFormattedDiffCommandStep.serialize(jsonUnexpectedDiff);
        String jsonChanged = InternalFormattedDiffCommandStep.serialize(jsonChangedDiff);
        String reportNameParameterName = reportArguments.isNameSetGlobally() ? ReportConfiguration.NAME.getKey() : "liquibase.command.diff.reportName";
        String reportPathParameterName = reportArguments.isPathSetGlobally() ? ReportConfiguration.PATH.getKey() : "liquibase.command.diff.reportPath";
        String reportFormatParameterName = reportArguments.isFormatSetGlobally() ? ReportConfiguration.FORMAT.getKey() : "liquibase.command.diff.reportFormat";
        String targetUrl = (String)commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG);
        String sourceUrl = (String)commandScope.getArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_URL_ARG);
        String args = ReportUtils.getDisplayArgs((String[])Scope.getCurrentScope().get("commandArguments", String[].class));
        String sqlDiff = UnifiedDiffUtil.generateUnifiedSqlDiff(textDriftReport);
        boolean foundDrift = numberMissing + numberUnexpected + numberChanged > 0;
        String liquibaseVersion = LiquibaseUtil.getBuildVersionInfo();
        String targetPlatformVersion = String.format("%s %s", database.getDatabaseProductName(), database.getDatabaseProductVersion());
        String referencePlatformVersion = String.format("%s %s", referenceDatabase.getDatabaseProductName(), referenceDatabase.getDatabaseProductVersion());
        String schemas = this.getSchemas(diffResult.getCompareControl());
        String diffTypes = diffResult.getComparedTypes().stream().map(textDriftReport::getSimpleTypeName).filter(Objects::nonNull).sorted().collect(Collectors.joining(", "));
        String excludeObjects = (String)Optional.ofNullable(commandScope.getArgumentValue(PreCompareCommandStep.EXCLUDE_OBJECTS_ARG)).orElse("");
        String includeObjects = (String)Optional.ofNullable(commandScope.getArgumentValue(PreCompareCommandStep.INCLUDE_OBJECTS_ARG)).orElse("");
        Boolean includeSchema = (Boolean)Optional.ofNullable(commandScope.getArgumentValue(DiffOutputControlCommandStep.INCLUDE_SCHEMA_ARG)).orElse(false);
        Boolean includeCatalog = (Boolean)Optional.ofNullable(commandScope.getArgumentValue(DiffOutputControlCommandStep.INCLUDE_CATALOG_ARG)).orElse(false);
        Boolean includeTablespace = (Boolean)Optional.ofNullable(commandScope.getArgumentValue(DiffOutputControlCommandStep.INCLUDE_TABLESPACE_ARG)).orElse(false);
        String commandName = this.getCommandName(commandScope.getCommand());
        ReportInfo reportInfo = new ReportInfo(name, commandName, localUser, hostName, path, args, reportNameParameterName, reportPathParameterName, reportFormatParameterName, liquibaseVersion, Arrays.equals(commandScope.getCommand().getName(), DiffChangelogCommandStep.COMMAND_NAME));
        DriftReportDatabaseInfo driftReportDatabaseInfo = new DriftReportDatabaseInfo(targetUrl, sourceUrl, targetPlatformVersion, referencePlatformVersion);
        DiffInfo diffInfo = new DiffInfo(foundDrift, !missing.isEmpty(), !unexpected.isEmpty(), !changed.isEmpty(), missing, unexpected, changed, jsonMissing, jsonUnexpected, jsonChanged, sqlDiff, String.valueOf(numberMissing), String.valueOf(numberUnexpected), String.valueOf(numberChanged), schemas, diffTypes, excludeObjects, includeObjects, includeSchema, includeCatalog, includeTablespace);
        DriftReportParameters driftReportParameters = new DriftReportParameters(reportInfo, driftReportDatabaseInfo, diffInfo);
        DriftReport driftReport = new DriftReport(name, path, driftReportParameters);
        driftReport.generateReport();
        if (Boolean.TRUE.equals(openInBrowser)) {
            this.openInBrowser(driftReport.getPathWithSuffix());
        }
        if (shouldReportDriftError) {
            throw resultsBuilder.commandFailed(String.format("ERROR: Liquibase detected drift of %d missing, %d changed, and %d unexpected objects between target '%s' and reference '%s'.%nFor additional details, inspect the output, set --format=JSON, or learn more at https://docs.liquibase.com/drift-reports.%nDiff command exited with error code %d", diffResult.getMissingObjects().size(), diffResult.getChangedObjects().size(), diffResult.getUnexpectedObjects().size(), database.getConnection().getURL(), referenceDatabase.getConnection().getURL(), driftError), driftError.intValue(), true);
        }
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public int getOrder(CommandDefinition commandDefinition) {
        boolean isDriftReportable;
        int result = super.getOrder(commandDefinition);
        boolean bl = isDriftReportable = commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0]) || commandDefinition.getName()[0].equals(DiffChangelogCommandStep.COMMAND_NAME[0]);
        if (result < 0 && !isDriftReportable) {
            return result;
        }
        return 1100;
    }

    private void openInBrowser(String path) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                desktop.open(new File(path));
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not open report in browser!", (Throwable)e);
        }
    }

    private String getSchemas(CompareControl compareControl) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (CompareControl.SchemaComparison schemaComparison : compareControl.getSchemaComparisons()) {
            schemas.add(schemaComparison.getComparisonSchema().getSchemaName());
            schemas.add(schemaComparison.getReferenceSchema().getSchemaName());
        }
        return schemas.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(", "));
    }

    private String getCommandName(CommandDefinition commandDefinition) {
        String camelCaseCommandName = Arrays.stream(commandDefinition.getName()).findFirst().orElse("drift");
        String splitCommandName = StringUtil.join((String[])StringUtil.splitCamelCase((String)camelCaseCommandName), (String)" ");
        return StringUtil.upperCaseFirst((String)splitCommandName);
    }

    static {
        DEFAULT_REPORT_NAMES = Arrays.asList(String.format("Diff-report-%s", "dd-MMM-yyyy-HHmmss"), String.format("Diff-changelog-report-%s", "dd-MMM-yyyy-HHmmss"));
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        OPEN_REPORT = builder.argument("openReport", Boolean.class).description("Open the Diff Report in your default browser.").defaultValue((Object)Boolean.FALSE).hidden().optional().build();
    }
}

