/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.license.LicenseServiceUtils;
import liquibase.report.ShowSummaryGenerator;
import liquibase.util.ShowSummaryUtil;

public class ProShowSummaryGenerator
implements ShowSummaryGenerator {
    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return 10;
        }
        return -1;
    }

    public List<ChangeSetStatus> getAllAdditionalChangeSetStatus(ChangeLogIterator runChangeLogIterator) {
        if (runChangeLogIterator == null) {
            return Collections.emptyList();
        }
        ArrayList<ChangeSetStatus> finalList = new ArrayList<ChangeSetStatus>();
        finalList.addAll(ProShowSummaryGenerator.getExceptionChangesets(runChangeLogIterator));
        finalList.addAll(ProShowSummaryGenerator.getSkippedDueToExceptionChangesets(runChangeLogIterator));
        return finalList;
    }

    private static List<ChangeSetStatus> getSkippedDueToExceptionChangesets(ChangeLogIterator runChangeLogIterator) {
        if (runChangeLogIterator == null) {
            return Collections.emptyList();
        }
        return runChangeLogIterator.getSkippedDueToExceptionChangeSets().stream().map(fcs -> ProShowSummaryGenerator.getChangeSetStatus(fcs, new ChangeSetFilterResult(false, "Update operation failed", SkippedDueToExceptionChangeSetFilter.class))).collect(Collectors.toList());
    }

    private static List<ChangeSetStatus> getExceptionChangesets(ChangeLogIterator runChangeLogIterator) {
        if (runChangeLogIterator == null) {
            return Collections.emptyList();
        }
        return runChangeLogIterator.getExceptionChangeSets().stream().map(fcs -> ProShowSummaryGenerator.getChangeSetStatus(fcs, new ChangeSetFilterResult(false, "Changeset failed to deploy", ExceptionChangeSetFilter.class))).collect(Collectors.toList());
    }

    public void appendAdditionalSummaryMessages(StringBuilder builder, ChangeLogIterator runChangeLogIterator) {
        if (runChangeLogIterator != null) {
            String message = String.format("Failed deployment:       %6d", ProShowSummaryGenerator.getExceptionChangesets(runChangeLogIterator).size() + ProShowSummaryGenerator.getSkippedDueToExceptionChangesets(runChangeLogIterator).size());
            builder.append(message);
            builder.append(System.lineSeparator());
        }
    }

    private static ChangeSetStatus getChangeSetStatus(ChangeSet fcs, ChangeSetFilterResult changeSetFilterResult) {
        ChangeSetStatus changeSetStatus = new ChangeSetStatus(fcs);
        changeSetStatus.setFilterResults(Collections.singleton(changeSetFilterResult));
        return changeSetStatus;
    }

    private static class SkippedDueToExceptionChangeSetFilter
    implements ShowSummaryUtil.ShouldNotCountAsSkipChangesetFilter {
        private SkippedDueToExceptionChangeSetFilter() {
        }

        public ChangeSetFilterResult accepts(ChangeSet changeSet) {
            return null;
        }
    }

    private static class ExceptionChangeSetFilter
    implements ShowSummaryUtil.ShouldNotCountAsSkipChangesetFilter {
        private ExceptionChangeSetFilter() {
        }

        public ChangeSetFilterResult accepts(ChangeSet changeSet) {
            return null;
        }
    }
}

