/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import liquibase.Scope;
import liquibase.database.jvm.JdbcConnection;
import liquibase.util.StringUtil;

public class ReportUtils {
    private ReportUtils() {
    }

    public static String getDisplayArgs(String[] args) {
        if (args == null) {
            return "";
        }
        ArrayList<String> cleanedDisplayArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String[] subParts;
            String part = args[i];
            if (part.toLowerCase().contains("url")) {
                String urlValue;
                part = part.replaceFirst("(.*?)=(.*)", "$1 $2");
                subParts = part.split(" ");
                cleanedDisplayArgs.add(subParts[0]);
                String string = urlValue = subParts.length > 1 ? subParts[1] : null;
                if (urlValue == null) {
                    if (i + 1 < args.length) {
                        urlValue = args[i + 1];
                    }
                    ++i;
                }
                if (urlValue != null) {
                    urlValue = JdbcConnection.sanitizeUrl((String)urlValue);
                    cleanedDisplayArgs.add(urlValue);
                    continue;
                }
                cleanedDisplayArgs.add(" ");
                continue;
            }
            if (part.toLowerCase().contains("password") || part.toLowerCase().contains("licensekey") || part.toLowerCase().contains("license-key")) {
                part = part.replaceFirst("(.*?)=(.*)", "$1 $2");
                subParts = part.split(" ");
                cleanedDisplayArgs.add(subParts[0]);
                cleanedDisplayArgs.add("*****");
                if (subParts.length != 1) continue;
                ++i;
                continue;
            }
            cleanedDisplayArgs.add(part);
        }
        return StringUtil.join(cleanedDisplayArgs, (String)" ");
    }

    public static void openInBrowser(String path) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                desktop.open(new File(path));
                Scope.getCurrentScope().getLog(ReportUtils.class).fine("Opened report in browser: " + path);
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(ReportUtils.class).warning("Could not open report in browser!", (Throwable)e);
        }
    }
}

