/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.api;

import com.datical.liquibase.ext.rules.api.Fact;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Facts
implements Iterable<Fact<?>> {
    private final Set<Fact<?>> facts = new HashSet();

    public <T> void put(String name, T value) {
        Objects.requireNonNull(name, "fact name must not be null");
        Objects.requireNonNull(value, "fact value must not be null");
        Fact<?> retrievedFact = this.getFact(name);
        if (retrievedFact != null) {
            this.remove(retrievedFact);
        }
        this.add(new Fact<T>(name, value));
    }

    public <T> void add(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        Fact<?> retrievedFact = this.getFact(fact.getName());
        if (retrievedFact != null) {
            this.remove(retrievedFact);
        }
        this.facts.add(fact);
    }

    public void remove(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        Fact<?> fact = this.getFact(factName);
        if (fact != null) {
            this.remove(fact);
        }
    }

    public <T> void remove(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        this.facts.remove(fact);
    }

    public <T> T get(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        Fact<?> fact = this.getFact(factName);
        if (fact != null) {
            return (T)fact.getValue();
        }
        return null;
    }

    public Fact<?> getFact(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        return this.facts.stream().filter(fact -> fact.getName().equals(factName)).findFirst().orElse(null);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Fact<?> fact : this.facts) {
            map.put(fact.getName(), fact.getValue());
        }
        return map;
    }

    @Override
    public Iterator<Fact<?>> iterator() {
        return this.facts.iterator();
    }

    public void clear() {
        this.facts.clear();
    }

    public String toString() {
        Iterator<Fact<?>> iterator = this.facts.iterator();
        StringBuilder stringBuilder = new StringBuilder("[");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

