/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.FactsAccessor;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseDynamicRule
extends AbstractLiquibaseRule {
    private static final Map<String, String> generatedSqlCache = new HashMap<String, String>();

    @Override
    public final boolean evaluate(Facts facts) {
        List changeSets = (List)new FactsAccessor().getFact(FactEnum.CHANGESETS.toString(), facts);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = (LazyDatabaseSnapshot)new FactsAccessor().getFact(FactEnum.DATABASE_SNAPSHOT.toString(), facts);
        if (changeSets == null && lazyDatabaseSnapshot == null && !this.hasResults(facts)) {
            return this.putResultSuccessful((ChangeSet)null, false, null);
        }
        Database database = (Database)new FactsAccessor().getFact(FactEnum.DATABASE.toString(), facts);
        DynamicRule dr = (DynamicRule)new FactsAccessor().getFact(FactEnum.INSTANCE_SETTINGS.toString(), facts);
        if (!this.validateParameters(dr)) {
            return this.putResultUnsuccessful((ChangeSet)null, "Validation failed on the parameters for this rule.", (AbstractConfigurableRule)dr);
        }
        AtomicBoolean result = new AtomicBoolean(false);
        if (changeSets != null) {
            for (ChangeSet changeSet : changeSets) {
                if (!this.shouldBeEvaluated(changeSet, (AbstractConfigurableRule)dr)) continue;
                HashMap scopedValues = new HashMap();
                try {
                    Scope.child(scopedValues, () -> {
                        boolean thisResult;
                        Map changeSetResults = (Map)new FactsAccessor().getFact(FactEnum.RULE_RESULTS.toString(), facts);
                        boolean bl = thisResult = changeSetResults != null ? this.internalEvaluate(changeSet, changeSetResults, dr, (CheckSettingsConfig)new FactsAccessor().getFact(FactEnum.CONFIG_SETTINGS.toString(), facts)) : this.internalEvaluate(changeSet, database, dr);
                        if (!result.get()) {
                            result.set(thisResult);
                        }
                        if (Boolean.TRUE.equals(new FactsAccessor().getFact(FactEnum.CHECK_ROLLBACKS.toString(), facts))) {
                            if (changeSetResults != null) {
                                this.internalRollbackEvaluate(changeSet, changeSetResults, dr, (CheckSettingsConfig)new FactsAccessor().getFact(FactEnum.CONFIG_SETTINGS.toString(), facts));
                            } else {
                                this.internalRollbackEvaluate(changeSet, changeSet.getRollback().getChanges(), database, dr);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                DiffResult diffResult = lazyDatabaseSnapshot.createDiffResult();
                Database snapshotDatabase = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
                    if (snapshotDatabase.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject, (AbstractConfigurableRule)dr)) continue;
                    Map databaseResults = (Map)new FactsAccessor().getFact(FactEnum.RULE_RESULTS.toString(), facts);
                    this.evaluateDatabaseObject(facts, databaseObject, lazyDatabaseSnapshot, databaseResults, dr, result);
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database snapshot, and thus failed to run the database checks.", e);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database snapshot", (AbstractConfigurableRule)dr);
            }
        }
        return result.get();
    }

    private void evaluateDatabaseObject(Facts facts, DatabaseObject databaseObject, LazyDatabaseSnapshot lazyDatabaseSnapshot, Map<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, DynamicRule dr, AtomicBoolean result) throws CommandExecutionException {
        try {
            HashMap<String, Object> scopedValues = new HashMap<String, Object>();
            scopedValues.put(FactEnum.DATABASE_SNAPSHOT.toString(), lazyDatabaseSnapshot.getSnapshot());
            scopedValues.put(FactEnum.DATABASE.toString(), lazyDatabaseSnapshot.getDatabase());
            Scope.child(scopedValues, () -> {
                boolean thisResult;
                boolean bl = thisResult = databaseResults != null ? this.internalEvaluate(databaseObject, databaseResults, dr, (CheckSettingsConfig)new FactsAccessor().getFact(FactEnum.CONFIG_SETTINGS.toString(), facts)) : this.internalEvaluate(databaseObject, dr);
                if (!result.get()) {
                    result.set(thisResult);
                }
            });
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
    }

    public static String generateSqlFromChange(Change change, Database database) throws IllegalStateException {
        SqlStatement[] statements;
        String key = AbstractLiquibaseDynamicRule.generateKey(change);
        if (generatedSqlCache.containsKey(key)) {
            return generatedSqlCache.get(key);
        }
        StringBuilder builder = new StringBuilder();
        for (SqlStatement statement : statements = change.generateStatements(database)) {
            Sql[] sqls;
            for (Sql oneSql : sqls = SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                builder.append(oneSql.toSql());
                builder.append("\n");
            }
        }
        generatedSqlCache.put(key, builder.toString());
        return builder.toString();
    }

    private static String generateKey(Change change) {
        return change.generateCheckSum().toString();
    }

    private boolean validateParameters(DynamicRule dynamicRule) {
        List<DynamicRuleParameter> parameters = dynamicRule.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            String message = String.format("Rule instance %s has no value parameters.  No check performed", dynamicRule.getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return false;
        }
        if ((long)parameters.size() < this.getParameters().stream().filter(p -> p.getShouldPrompt() == null && !p.isAddedAfterRelease()).count()) {
            String message = String.format("Rule instance %s has some missing value parameters.  No check performed.%nRun checks customize to supply values for the missing parameters.", dynamicRule.getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return false;
        }
        return true;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, DynamicRule var2);

    public abstract boolean internalEvaluate(DatabaseObject var1, DynamicRule var2);

    public boolean internalEvaluate(ChangeSet changeSet, Map<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return true;
    }

    public boolean internalEvaluate(DatabaseObject databaseObject, Map<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return true;
    }

    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.internalEvaluate(changeSet, dynamicRule);
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, Map<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return false;
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return false;
    }
}

