/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.x500;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import net.java.truelicense.core.util.Builder;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.core.x500.X500AttributeTypeKeyword;
import net.java.truelicense.obfuscate.ObfuscatedString;

public abstract class GenericX500PrincipalBuilder<This extends GenericX500PrincipalBuilder<This>>
implements Builder<X500Principal> {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, String> keywords = new HashMap<String, String>();

    public This addCN(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.CN, string);
    }

    public This addL(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.L, string);
    }

    public This addST(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.ST, string);
    }

    public This addO(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.O, string);
    }

    public This addOU(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.OU, string);
    }

    public This addC(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.C, string);
    }

    public This addSTREET(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.STREET, string);
    }

    public This addDC(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DC, string);
    }

    public This addUID(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.UID, string);
    }

    public This addT(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.T, string);
    }

    public This addDNQ(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DNQ, string);
    }

    public This addDNQUALIFIER(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.DNQUALIFIER, string);
    }

    public This addSURNAME(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.SURNAME, string);
    }

    public This addGIVENNAME(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.GIVENNAME, string);
    }

    public This addINITIALS(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.INITIALS, string);
    }

    public This addGENERATION(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.GENERATION, string);
    }

    public This addEMAILADDRESS(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.EMAILADDRESS, string);
    }

    public This addSERIALNUMBER(@Nullable String string) {
        return this.addAttribute(X500AttributeTypeKeyword.SERIALNUMBER, string);
    }

    public This addAttribute(X500AttributeTypeKeyword x500AttributeTypeKeyword, @Nullable String string) {
        return this.addAttribute(x500AttributeTypeKeyword.name(), string);
    }

    public This addAttribute(String string, @Nullable String string2) {
        Objects.requireNonNull(string);
        if (null != string2) {
            this.attributes.put(string, string2);
        } else {
            this.attributes.remove(string);
        }
        return (This)this;
    }

    public This addKeyword(String string, @Nullable String string2) {
        Objects.requireNonNull(string);
        if (null != string2) {
            this.keywords.put(string, string2);
        } else {
            this.keywords.remove(string);
        }
        return (This)this;
    }

    @Override
    public X500Principal build() {
        DistinguishedNameAssembler distinguishedNameAssembler = new DistinguishedNameAssembler();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            distinguishedNameAssembler.appendAttribute(entry.getKey(), entry.getValue());
        }
        return new X500Principal(distinguishedNameAssembler.toString(), this.keywords);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class DistinguishedNameAssembler {
        private static final Pattern QUOTED_CHARACTERS_PATTERN;
        private final StringBuilder dname = new StringBuilder();

        private DistinguishedNameAssembler() {
        }

        void appendAttribute(String string, String string2) {
            this.delimitAttribute();
            this.dname.append(string).append('=');
            boolean bl = DistinguishedNameAssembler.needsQuoting(string2);
            if (bl) {
                this.dname.append('\"');
            }
            this.dname.append(DistinguishedNameAssembler.escapeBackslashAndQuote(string2));
            if (bl) {
                this.dname.append('\"');
            }
        }

        private void delimitAttribute() {
            if (0 < this.dname.length()) {
                this.dname.append(',');
            }
        }

        private static boolean needsQuoting(String string) {
            return !string.equals(string.trim()) || string.startsWith(DistinguishedNameAssembler._string#1()) || QUOTED_CHARACTERS_PATTERN.matcher(string).matches();
        }

        private static String escapeBackslashAndQuote(String string) {
            return string.replace(DistinguishedNameAssembler._string#2(), DistinguishedNameAssembler._string#3()).replace(DistinguishedNameAssembler._string#4(), DistinguishedNameAssembler._string#5());
        }

        public String toString() {
            return this.dname.toString();
        }

        static {
            DistinguishedNameAssembler.QUOTED_CHARACTERS_PATTERN = Pattern.compile(DistinguishedNameAssembler._string#6());
        }

        private static final /* synthetic */ String QUOTED_CHARACTERS_SEQUENCE() {
            return new ObfuscatedString(new long[]{821849962455880809L, -3677095095234100129L}).toString();
        }

        private static /* synthetic */ String _string#1() {
            return new ObfuscatedString(new long[]{-1153480406913480068L, -2947100384440758671L}).toString();
        }

        private static /* synthetic */ String _string#2() {
            return new ObfuscatedString(new long[]{-1220693625525895407L, 7161497020698683840L}).toString();
        }

        private static /* synthetic */ String _string#3() {
            return new ObfuscatedString(new long[]{-5262238580475851846L, -1538315612527679930L}).toString();
        }

        private static /* synthetic */ String _string#4() {
            return new ObfuscatedString(new long[]{-2934417843494741363L, 7946322624457982088L}).toString();
        }

        private static /* synthetic */ String _string#5() {
            return new ObfuscatedString(new long[]{1078444252955258047L, -4265035202277302811L}).toString();
        }

        private static /* synthetic */ String _string#6() {
            return new ObfuscatedString(new long[]{8815322566260574582L, 1197491233437467668L, 4445554887273015472L}).toString();
        }
    }
}

