/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymStatement;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import java.util.Arrays;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropSynonym", description="Drops a synonym", priority=101, appliesTo={"synonym"})
public class DropSynonymChange
extends LicenseValidationChange {
    private Boolean isPrivate;
    private String synonymCatalogName;
    private String synonymSchemaName;
    private String synonymName;
    private String objectType;
    private static final List<Class<? extends Database>> SUPPORTED_DATABASES = Arrays.asList(OracleDatabase.class, MSSQLDatabase.class, AbstractDb2Database.class, PostgresDatabase.class);

    @Override
    public ValidationErrors validate(Database database) {
        if (this.supports(database)) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    public boolean supports(Database database) {
        return SUPPORTED_DATABASES.stream().anyMatch(databaseClass -> databaseClass.isAssignableFrom(database.getClass()));
    }

    @DatabaseChangeProperty(description="If true, the synonym can only be accessed by the creator. If false, the synonym can be accessed by PUBLIC.")
    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @DatabaseChangeProperty(description="Name of the database catalog of the synonym")
    public String getSynonymCatalogName() {
        return this.synonymCatalogName;
    }

    public void setSynonymCatalogName(String synonymCatalogName) {
        this.synonymCatalogName = synonymCatalogName;
    }

    @DatabaseChangeProperty(description="Name of the database schema of the synonym")
    public String getSynonymSchemaName() {
        return this.synonymSchemaName;
    }

    public void setSynonymSchemaName(String synonymSchemaName) {
        this.synonymSchemaName = synonymSchemaName;
    }

    @DatabaseChangeProperty(description="Name of the synonym")
    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymName(String synonymName) {
        this.synonymName = synonymName;
    }

    @DatabaseChangeProperty(description="Data type of the object represented by the synonym")
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getConfirmationMessage() {
        return "Synonym " + this.getSynonymName() + " dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropSynonymStatement(this.getSynonymCatalogName(), this.getSynonymSchemaName(), this.getSynonymName()).setPrivate(this.isPrivate()).setObjectType(this.getObjectType())};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

