/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.SnapshotControlUtil;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandOverride;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.SnapshotReferenceCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.SnapshotControl;

@CommandOverride(override=SnapshotReferenceCommandStep.class)
public class ProReferenceSnapshotCommandStep
extends SnapshotReferenceCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"snapshotReference"};
    public static final CommandArgumentDefinition<String> SNAPSHOT_FILTERS_ARG;

    protected SnapshotControl createSnapshotControl(CommandScope commandScope, Database database) {
        String typesString = (String)commandScope.getArgumentValue(SNAPSHOT_FILTERS_ARG);
        if (commandScope.getArgumentValue(SNAPSHOT_CONTROL_ARG) != null || typesString == null) {
            return super.createSnapshotControl(commandScope, database);
        }
        return SnapshotControlUtil.createSnapshotControl(database, typesString);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        SNAPSHOT_FILTERS_ARG = builder.argument("snapshotFilters", String.class).description(ProStringUtil.markWithPro("Types of objects to snapshot: " + SnapshotControlUtil.getAvailableTypes())).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            try {
                LicenseServiceUtils.checkProLicenseAndThrowException((String[])new String[]{"Snapshot with filters"});
            }
            catch (CommandExecutionException cve) {
                throw new IllegalArgumentException(cve.getMessage());
            }
            String typesString = (String)input;
            try {
                DiffCommandStep.parseSnapshotTypes((String[])new String[]{typesString});
            }
            catch (UnexpectedLiquibaseException ule) {
                String message = ule.getMessage();
                if (message != null) {
                    message = message.replace("Unknown snapshot type(s) ", "Unknown snapshot filter(s) '");
                }
                String messageString = String.format("%nWARNING: %s'. %nValid snapshot filter types are %s", message, SnapshotControlUtil.getStandardTypes());
                throw new IllegalArgumentException(messageString);
            }
            return typesString;
        }).build();
    }
}

