/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.condition;

import com.datical.liquibase.ext.flow.condition.FlowFileUtil;
import com.datical.liquibase.ext.flow.condition.FlowStringUtil;
import com.datical.liquibase.ext.flow.condition.OperatorFactory;
import com.datical.liquibase.ext.flow.condition.operator.ConditionOperator;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.LiquibaseConfiguration;
import lombok.Generated;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;
import org.mvel2.integration.impl.SimpleVariableResolverFactory;

public class Condition {
    public static final String FLOW_STRING_UTIL = FlowStringUtil.class.getSimpleName();
    public static final String FLOW_FILE_UTIL = FlowFileUtil.class.getSimpleName();
    public static final String CONDITION_VARIABLES = "conditionVariables";
    private final String leftOperand;
    private final ConditionOperator operator;
    private final String rightOperand;
    private final String rawConditionText;
    private final String originalConditionText;
    private final String expandedConditionWithoutQuotes;
    private final Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private final ParserContext parserContext;
    private static final List<Method> stringUtilMethods = new ArrayList<Method>();
    private static final List<Method> flowUtilMethods = new ArrayList<Method>();
    private static final OperatorFactory operatorFactory = (OperatorFactory)Scope.getCurrentScope().getSingleton(OperatorFactory.class);

    public Condition(String leftOperand, ConditionOperator operator, String rightOperand, String rawConditionText) {
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
        this.rawConditionText = rawConditionText;
        this.originalConditionText = rawConditionText;
        this.expandedConditionWithoutQuotes = null;
        this.parserContext = new ParserContext();
    }

    public Condition(String rawConditionText, String originalConditionText, Map<String, Object> variables, String expandedConditionWithoutQuotes) {
        this.leftOperand = null;
        this.operator = null;
        this.rightOperand = null;
        this.rawConditionText = rawConditionText;
        this.originalConditionText = originalConditionText;
        this.expandedConditionWithoutQuotes = expandedConditionWithoutQuotes;
        this.variables.putAll(variables);
        this.parserContext = new ParserContext();
        this.parserContext.addImport(FlowStringUtil.class);
        this.parserContext.addImport(FlowFileUtil.class);
    }

    public static Condition fromString(String condition, Map<String, Object> variables) {
        if (FlowStringUtil.isEmpty(condition)) {
            return null;
        }
        variables = variables == null ? Collections.emptyMap() : FlowVariableExpander.expandVariables(variables, variables);
        Map<String, Object> finalVariables = variables;
        variables.forEach((k, v) -> {
            if (v != null && v.equals("null")) {
                finalVariables.put((String)k, null);
            }
        });
        AtomicReference<String> editedCondition = new AtomicReference<String>(condition);
        Condition.handleMethodCalls(editedCondition);
        AtomicReference reference = new AtomicReference();
        AtomicReference<Map<String, Object>> referenceMap = new AtomicReference<Map<String, Object>>(variables);
        try {
            Scope.child((String)"QUOTE_REPLACEMENT", (Object)true, () -> {
                Map<String, Object> expandedCondition = Condition.expandVariables(editedCondition, referenceMap);
                String string = expandedCondition.get("if").toString();
                if (string != null && string.contains("${") && string.contains("}")) {
                    throw new RuntimeException(String.format("There are unresolved variables.", new Object[0]));
                }
                reference.set(string);
            });
        }
        catch (Exception e) {
            String message = String.format("Unable to create condition for expression '%s': %s", condition, e.getMessage());
            Scope.getCurrentScope().getLog(Condition.class).warning(message);
            throw new RuntimeException(message, e);
        }
        Map<String, Object> expandedConditionWithoutQuoteReplacement = Condition.expandVariables(editedCondition, referenceMap);
        return new Condition((String)reference.get(), condition, referenceMap.get(), expandedConditionWithoutQuoteReplacement.get("if").toString());
    }

    private static void handleMethodCalls(AtomicReference<String> editedCondition) {
        Condition.editMethodCalls(stringUtilMethods, editedCondition, FLOW_STRING_UTIL);
        Condition.editMethodCalls(flowUtilMethods, editedCondition, FLOW_FILE_UTIL);
    }

    private static void editMethodCalls(List<Method> methods, AtomicReference<String> editedCondition, String simpleClassName) {
        methods.forEach(m -> {
            String name = m.getName();
            String c = (String)editedCondition.get();
            String patternString = "(?<!" + simpleClassName + "\\.)(" + name + "[ ]*\\()";
            Pattern p = Pattern.compile(patternString, 2);
            Matcher matcher = p.matcher(c);
            while (matcher.find()) {
                c = c.replace(matcher.group(1), simpleClassName + "." + name + "(");
                editedCondition.set(c);
            }
            c = (String)editedCondition.get();
            String methodPatternString = ".*\\.(" + name + ")[ ]*\\(";
            Pattern methodPattern = Pattern.compile(methodPatternString, 2);
            Matcher methodMatcher = methodPattern.matcher(c);
            while (methodMatcher.find()) {
                c = c.replace(methodMatcher.group(1), name);
                editedCondition.set(c);
            }
        });
    }

    private static ConfigurationValueObfuscator<?> createObfuscator(String name) {
        if (name != null && (name.equalsIgnoreCase("password") || name.toLowerCase().contains("licensekey"))) {
            return ConfigurationValueObfuscator.STANDARD;
        }
        return null;
    }

    private static Map<String, Object> expandVariables(AtomicReference<String> editedCondition, AtomicReference<Map<String, Object>> referenceMap) {
        Map<String, Object> expandedCondition = FlowVariableExpander.expandVariables(Collections.singletonMap("if", editedCondition.get()), referenceMap.get());
        AtomicReference<Map<String, Object>> refExpandedCondition = new AtomicReference<Map<String, Object>>();
        refExpandedCondition.set(expandedCondition);
        try {
            Scope.child((String)CONDITION_VARIABLES, referenceMap.get(), () -> refExpandedCondition.set(FlowVariableExpander.execShellCommandsToExpand(expandedCondition)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Map)refExpandedCondition.get();
    }

    public static Condition createCondition(String condition, Map<String, Object> variables) {
        List operators = Scope.getCurrentScope().getServiceLocator().findInstances(ConditionOperator.class);
        if (operators.isEmpty()) {
            throw new RuntimeException("No condition operators found.");
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        Map<String, Object> expandedCondition = FlowVariableExpander.expandVariables(Collections.singletonMap("if", condition), variables);
        condition = expandedCondition.get("if").toString();
        String regex = String.format("(?<leftOperand>.+)\\s*(?<operator>%s)\\s*(?<rightOperand>.+)", operators.stream().map(ConditionOperator::getTextualRepresentation).collect(Collectors.joining("|")));
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(condition.trim());
        if (matcher.matches()) {
            String operatorText = matcher.group("operator");
            ConditionOperator operator = operatorFactory.create(operatorText);
            if (operator == null) {
                throw new IllegalArgumentException("Operator '" + operatorText + "' not recognized.");
            }
            return new Condition(matcher.group("leftOperand").trim(), operator, matcher.group("rightOperand").trim(), condition);
        }
        throw new IllegalArgumentException("Condition '" + condition + "' cannot be parsed.");
    }

    public static String handleCompileException(CompileException e) {
        String[] parts;
        String message = e.getMessage();
        if (message != null && (parts = message.split(";")).length > 1) {
            message = parts[0].replace("[Error: could not access: ", "");
        }
        message = String.format("%nUnable to resolve MVEL property '%s'.  Evaluating with Liquibase implementation", message);
        Scope.getCurrentScope().getLog(Condition.class).fine(message);
        return message;
    }

    public boolean evaluate() {
        String conditionText = this.getRawConditionText();
        if (conditionText == null) {
            throw new RuntimeException("No condition available to evaluate");
        }
        if (conditionText.contains("${") && conditionText.contains("}")) {
            throw new RuntimeException(String.format("%nUnable to evaluate condition '%s'.  There are unresolved variables.", conditionText));
        }
        try {
            FlowVariableResolverFactory resolverFactory = new FlowVariableResolverFactory(this.variables);
            Serializable s = MVEL.compileExpression(conditionText, this.parserContext);
            return (Boolean)MVEL.executeExpression((Object)s, this.variables, (VariableResolverFactory)resolverFactory);
        }
        catch (CompileException e) {
            Condition condition;
            String message = Condition.handleCompileException(e);
            try {
                condition = Condition.createCondition(this.expandedConditionWithoutQuotes, this.variables);
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException(message, iae);
            }
            return condition.getOperator().evaluate(condition.getLeftOperand(), condition.getRightOperand());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        if (this.leftOperand == null && this.rightOperand == null) {
            return condition.evaluate();
        }
        if (this.leftOperand == null || this.rightOperand == null) {
            return false;
        }
        return this.leftOperand.equals(condition.leftOperand) && this.operator.getClass().equals(condition.operator.getClass()) && this.rightOperand.equals(condition.rightOperand);
    }

    public int hashCode() {
        return Objects.hash(this.leftOperand, this.operator, this.rightOperand);
    }

    @Generated
    public String getLeftOperand() {
        return this.leftOperand;
    }

    @Generated
    public ConditionOperator getOperator() {
        return this.operator;
    }

    @Generated
    public String getRightOperand() {
        return this.rightOperand;
    }

    @Generated
    public String getRawConditionText() {
        return this.rawConditionText;
    }

    @Generated
    public String getOriginalConditionText() {
        return this.originalConditionText;
    }

    @Generated
    public String getExpandedConditionWithoutQuotes() {
        return this.expandedConditionWithoutQuotes;
    }

    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public ParserContext getParserContext() {
        return this.parserContext;
    }

    static {
        stringUtilMethods.addAll(Arrays.asList(FlowStringUtil.class.getMethods()));
        flowUtilMethods.addAll(Arrays.asList(FlowFileUtil.class.getMethods()));
    }

    private static class FlowVariableResolverFactory
    extends SimpleVariableResolverFactory {
        public FlowVariableResolverFactory(Map<String, Object> variables) {
            super(variables);
        }

        @Override
        public boolean isResolveable(String name) {
            if (name != null && name.contains("${") && name.contains("}")) {
                throw new RuntimeException(String.format("%nUnable to evaluate condition '%s'.  There are unresolved variables.", name));
            }
            boolean b = super.isResolveable(name);
            if (!b) {
                b = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getCurrentConfiguredValue(null, Condition.createObfuscator(name), new String[]{name}).getValue() != null;
            }
            return b;
        }

        @Override
        public VariableResolver getVariableResolver(String name) {
            if (!super.isResolveable(name)) {
                return new FlowVariableResolver(name);
            }
            return super.getVariableResolver(name);
        }
    }

    private static class FlowVariableResolver
    extends SimpleValueResolver {
        private final String name;

        public FlowVariableResolver(String name) {
            super(null);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getCurrentConfiguredValue(null, Condition.createObfuscator(this.getName()), new String[]{this.getName()}).getValue();
        }
    }
}

