/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.custommdc;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.logging.custommdc.Cache;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataYaml;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandValidationException;
import liquibase.logging.core.NoOpLogService;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;

public class CustomLogDataFile {
    public static final String GLOBAL_CUSTOM_DATA_KEY = "liquibase.usermetadata";
    private static final Cache<Resource> resource = new Cache<Resource>(() -> {
        ConfiguredValue customLogDataConfigValue = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        try {
            String customLogDataFilename = (String)customLogDataConfigValue.getValue();
            Resource customLogDataResource = (Resource)Scope.child(Collections.singletonMap(Scope.Attr.logService.toString(), new NoOpLogService()), () -> pathHandlerFactory.getResource(customLogDataFilename));
            if (!customLogDataConfigValue.wasDefaultValueUsed() && !customLogDataResource.exists()) {
                throw new FileNotFoundException(customLogDataFilename + " not found.");
            }
            return customLogDataResource;
        }
        catch (Exception e) {
            throw new CommandValidationException((Throwable)e);
        }
    });
    private static final Cache<Map<String, Object>> fileContents = new Cache<Map>(() -> {
        Map<String, Object> customMdcData;
        CustomLogDataYaml yaml = new CustomLogDataYaml();
        try (InputStream is = resource.get().openInputStream();){
            customMdcData = (Map<String, Object>)yaml.load(is);
        }
        Map<String, Object> replaced = CustomLogDataFile.safelyExpandEnvVars(customMdcData);
        if (replaced != null) {
            customMdcData = replaced;
        }
        return customMdcData;
    });

    private CustomLogDataFile() {
    }

    private static Map<String, Object> safelyExpandEnvVars(Map<String, Object> value) {
        try {
            return (Map)Scope.child(Collections.singletonMap(Scope.Attr.logService.toString(), new NoOpLogService()), () -> FlowVariableExpander.expandVariables(value, Collections.emptyMap(), true));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Resource getResource() throws Exception {
        return resource.get();
    }

    public static Map<String, Object> getFileContents() throws Exception {
        return fileContents.get();
    }

    public static void clearCache() {
        resource.clearCache();
        fileContents.clearCache();
    }
}

