/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.postgres;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.TriggerSnapshotGenerator;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public class PostgresTriggerSnapshotGenerator
extends TriggerSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        return -1;
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        String jdbcSchemaName = ((PostgresDatabase)database).getJdbcSchemaName(schema.toCatalogAndSchema());
        if (jdbcSchemaName == null) {
            jdbcSchemaName = database.getDefaultSchemaName();
        }
        return String.format("select trg.tgname as OBJECT_NAME FROM pg_trigger trg\n JOIN pg_class tbl on trg.tgrelid = tbl.oid\n JOIN pg_namespace ns on ns.oid = tbl.relnamespace  \n  and trg.tgisinternal=false and ns.nspname = '%s'\n", jdbcSchemaName);
    }

    @Override
    public String getSnapshotObjectSql(DatabaseObject databaseObject, Database database) {
        String getSnapshotObjectSql = "select trg.tgname as OBJECT_NAME,   case     when trg.tgenabled='O' then 'ENABLED'     else 'DISABLED'     end as TRIGGER_STATUS, 'VALID' as status,   pg_get_triggerdef(trg.oid) as OBJECT_BODY,  ns.nspname as SCHEMA_NAME, tbl.relname as TABLE_NAME   FROM pg_trigger trg    JOIN pg_class tbl on trg.tgrelid = tbl.oid    JOIN pg_namespace ns ON ns.oid = tbl.relnamespace  and trg.tgisinternal=false ";
        if (databaseObject instanceof Catalog) {
            return null;
        }
        if (databaseObject instanceof Schema) {
            String jdbcSchemaName = ((PostgresDatabase)database).getJdbcSchemaName(databaseObject.getSchema().toCatalogAndSchema());
            if (jdbcSchemaName == null) {
                jdbcSchemaName = database.getDefaultSchemaName();
            }
            getSnapshotObjectSql = getSnapshotObjectSql + String.format(" where ns.nspname = '%s' ", jdbcSchemaName);
            return getSnapshotObjectSql;
        }
        if (databaseObject instanceof Trigger) {
            getSnapshotObjectSql = getSnapshotObjectSql + String.format(" WHERE trg.tgname = '%s' and ns.nspname = '%s' ", database.correctObjectName(databaseObject.getName(), Trigger.class), databaseObject.getSchema().getName());
        }
        return getSnapshotObjectSql;
    }
}

