/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.MatcherContext;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import liquibase.change.Change;
import liquibase.change.core.DropTableChange;

public class WarnOnTableDrops
extends AbstractNotAllowedToContainRule {
    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("drop[\\s]*table[\\s]*"), Pattern.compile("drop[\\s]*table\\["));
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that changesets which result in tables being dropped are reviewed carefully to prevent the unintentional loss of data.  Review this changeset to confirm that the referenced table is being dropped safely.";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a table is being dropped so that they can ensure that dropping the table won't lead to unintentional loss of data.";
    }

    @Override
    public String getName() {
        return "Warn when 'DROP TABLE' detected";
    }

    @Override
    public String getShortName() {
        return "ChangeDropTableWarn";
    }

    @Override
    public int getPriority() {
        return 30;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.singletonList(DropTableChange.class);
    }

    @Override
    public MatcherContext doCheck(Change change) {
        MatcherContext matcherContext = new MatcherContext();
        matcherContext.matchResult = change instanceof DropTableChange;
        return matcherContext;
    }
}

