/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.logging.custommdc.Cache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import liquibase.util.StringUtil;

public class StringListGetter
extends AbstractCommandLineValueGetter<String> {
    private final Cache<Set<String>> validOptions;

    public StringListGetter() {
        this((Cache<Set<String>>)null);
    }

    public StringListGetter(Cache<Set<String>> validOptions) {
        super(String.class);
        this.validOptions = validOptions;
    }

    @Override
    public boolean validate(String input) {
        try {
            return StringListGetter.validate(input, (Set)this.validOptions.get(), "is not a valid word.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String convert(String input) {
        return input.toUpperCase();
    }

    public static boolean validate(String input, Set<String> validOptions, String errorMessage) {
        if (validOptions != null) {
            List<String> splits = StringListGetter.split(input);
            for (String split : splits) {
                String upper = split.toUpperCase();
                if (validOptions.contains(upper)) continue;
                throw new IllegalArgumentException(split + " " + errorMessage.trim());
            }
        }
        return true;
    }

    public static List<String> split(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return Collections.emptyList();
        }
        return StringUtil.splitAndTrim((String)input, (String)",");
    }

    /*
     * Loose catch block
     */
    @Override
    public String describe() {
        block5: {
            if (this.validOptions != null && !((Set)this.validOptions.get()).isEmpty()) break block5;
            return "comma-separated list";
            {
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            return "comma-separated list; valid values: " + StringUtil.join((Collection)((Collection)this.validOptions.get()), (String)", ");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

