/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.output;

import com.datical.liquibase.ext.rules.core.RuleIteration;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.util.StringUtil;

public class ChecksOutputUtil {
    public static String determineLineNumberForMatch(RuleIteration ruleIteration) {
        if (ruleIteration.getMatcherContext() == null) {
            return "";
        }
        String sqlText = ruleIteration.getMatcherContext().sqlText;
        if (StringUtil.isEmpty((String)sqlText)) {
            return "";
        }
        String[] lines = (sqlText = sqlText.replace("\r", "")).split("\n");
        if (lines.length == 1) {
            return ": Line 1";
        }
        int start = ruleIteration.getMatcherContext().start;
        int end = ruleIteration.getMatcherContext().end;
        int position = 0;
        int counter = 1;
        for (String line : lines) {
            if (start >= position && end <= position + line.length()) {
                return ": Line " + counter;
            }
            position += line.length() + 1;
            ++counter;
        }
        return "";
    }

    public static String determineChangesetFilePath(ChangeSet changeSet, Change change) {
        if (!(change instanceof SQLFileChange)) {
            return changeSet.getFilePath();
        }
        SQLFileChange sqlFileChange = (SQLFileChange)change;
        if (sqlFileChange.getPath() != null) {
            return changeSet.getFilePath() + " :: " + sqlFileChange.getPath();
        }
        return changeSet.getFilePath();
    }
}

