/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import java.util.Arrays;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.ExecuteSqlCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ForecastDMLCommandStep
extends ExecuteSqlCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"forecastDML"};
    public static final CommandArgumentDefinition<String> SQL_ARG;
    public static final CommandArgumentDefinition<String> SQLFILE_ARG;
    public static final CommandArgumentDefinition<String> DELIMITER_ARG;
    public static final CommandArgumentDefinition<String> DML_PREFIX_ARG;

    public void validate(CommandScope commandScope) throws CommandValidationException {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])commandScope.getCommand().getName());
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Forecast DML Update SQL for number of rows affected");
        commandDefinition.setHidden(true);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        String dmlPrefix = (String)commandScope.getArgumentValue(DML_PREFIX_ARG);
        String sql = (String)commandScope.getArgumentValue(SQL_ARG);
        String sqlFile = (String)commandScope.getArgumentValue(SQLFILE_ARG);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        String sqlText = this.getSqlScript(sql, sqlFile);
        if (StringUtils.isEmpty((CharSequence)sqlText)) {
            throw new LiquibaseException("There is no SQL to use for forecasting DML");
        }
        String[] sqlStrings = StringUtil.processMultiLineSQL((String)sqlText, (boolean)true, (boolean)true, (String)ForecastDMLCommandStep.determineEndDelimiter((CommandScope)commandScope));
        StringBuilder out = new StringBuilder();
        boolean originalAutoCommit = database.getConnection().getAutoCommit();
        try {
            database.getConnection().setAutoCommit(false);
            Arrays.stream(sqlStrings).filter(sqlString -> sqlString.toLowerCase().trim().startsWith(dmlPrefix)).forEach(sqlString -> {
                int count;
                try {
                    count = executor.update((SqlStatement)new RawSqlStatement(sqlString));
                }
                catch (DatabaseException e) {
                    throw new RuntimeException(e);
                }
                out.append("Successfully Executed: ").append((String)sqlString).append("\n");
                out.append("Rows Affected: ").append(count).append("\n");
                resultsBuilder.addResult("rowsAffected_" + sqlString, (Object)count);
            });
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        finally {
            database.getConnection().setAutoCommit(originalAutoCommit);
        }
        database.rollback();
        Scope.getCurrentScope().getLog(ForecastDMLCommandStep.class).fine(out.toString());
        resultsBuilder.addResult("output", (Object)out.toString());
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        SQL_ARG = builder.argument("sql", String.class).description("SQL string to execute").build();
        SQLFILE_ARG = builder.argument("sqlFile", String.class).description("SQL script to execute").build();
        DELIMITER_ARG = builder.argument("delimiter", String.class).description("Delimiter to use when executing SQL script").build();
        DML_PREFIX_ARG = builder.argument("dmlPrefix", String.class).required().description("Starting string in DML Statement (update, insert, delete)").build();
    }
}

