/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep;
import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.util.LoggingExecutorTextUtil;

public class RollbackOneChangesetSqlCommandStep
extends RollbackOneChangesetCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneChangesetSql"};
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_SCHEMA_ARG;
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_CATALOG_ARG;

    @Override
    public List<Class<?>> requiredDependencies() {
        ArrayList dependencies = new ArrayList();
        dependencies.add(Writer.class);
        dependencies.addAll(super.requiredDependencies());
        dependencies.removeIf(aClass -> aClass.isAssignableFrom(ReportCommandArguments.class));
        return dependencies;
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        Boolean outputDefaultCatalog = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_CATALOG_ARG);
        Boolean outputDefaultSchema = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_SCHEMA_ARG);
        String changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        String changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        String changeSetString = changeSetPath + "::" + changeSetId + "::" + changeSetAuthor;
        Boolean force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        commandScope.addArgumentValue(FORCE_ARG, (Object)(force == null || force != false ? 1 : 0));
        database.setOutputDefaultCatalog(outputDefaultCatalog.booleanValue());
        database.setOutputDefaultSchema(outputDefaultSchema.booleanValue());
        LoggingExecutorTextUtil.outputHeader((String)("Rollback changeset '" + changeSetString + "'"), (Database)database, (String)databaseChangeLog.getFilePath());
        super.run(resultsBuilder);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one changeset from the database"));
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        OUTPUT_DEFAULT_SCHEMA_ARG = builder.argument("outputDefaultSchema", Boolean.class).description("Control whether names of objects in the default schema are fully qualified or not. If true they are. If false, only objects outside the default schema are fully qualified").defaultValue((Object)true).build();
        OUTPUT_DEFAULT_CATALOG_ARG = builder.argument("outputDefaultCatalog", Boolean.class).description("Control whether names of objects in the default catalog are fully qualified or not. If true they are. If false, only objects outside the default catalog are fully qualified").defaultValue((Object)true).build();
        FORCE_ARG = builder.argument("force", Boolean.class).hidden().build();
        builder.addArgument(CHANGESET_ID_ARG).build();
        builder.addArgument(CHANGESET_AUTHOR_ARG).build();
        builder.addArgument(CHANGESET_PATH_ARG).build();
        builder.addArgument(ROLLBACK_SCRIPT_ARG).build();
        builder.addArgument(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK).hidden().build();
    }
}

