/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.storedproc.StoredProcedureSnapshotGenerator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.StringUtil;

public class SnowflakeStoredProcedureSnapshotGenerator
extends StoredProcedureSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof SnowflakeDatabase) {
            int parentPriority = super.getPriority(objectType, database);
            if (parentPriority > 0) {
                return 50;
            }
            return parentPriority;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{StoredProcedureSnapshotGenerator.class};
    }

    public String parseArguments(String argument) {
        return argument.replaceAll("\\w+\\s", "");
    }

    public String getBody(StoredDatabaseLogic<?> storedDatabaseLogicExample, String arguments, Database database) throws DatabaseException {
        String sql = " SELECT GET_DDL('procedure', ?)";
        String procedureNameAndArguments = String.format("%s%s", database.escapeObjectName(storedDatabaseLogicExample.getSchema().getCatalogName(), storedDatabaseLogicExample.getSchema().getName(), storedDatabaseLogicExample.getName(), StoredProcedure.class), arguments);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        return (String)executor.queryForObject((SqlStatement)new RawParameterizedSqlStatement(sql, new Object[]{procedureNameAndArguments}), String.class);
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        String name = null;
        for (Map<String, ?> row : rs) {
            if (name == null) {
                name = (String)row.get("OBJECT_NAME");
            }
            String arguments = this.parseArguments((String)row.get("OBJECT_ARG"));
            String objectBody = this.getBody(storedDatabaseLogicExample, arguments, database);
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n")));
        StoredDatabaseLogic storedDatabaseLogic = ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema())).setName(name)).setBody(body.toString());
        return storedDatabaseLogic;
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) throws DatabaseException {
        return "SELECT PROCEDURE_NAME AS OBJECT_NAME FROM INFORMATION_SCHEMA.PROCEDURES where PROCEDURE_SCHEMA='" + schema.getName() + "'";
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> example, Database database) throws DatabaseException {
        return "SELECT PROCEDURE_SCHEMA AS OBJECT_SCHEMA, PROCEDURE_NAME AS OBJECT_NAME, ARGUMENT_SIGNATURE as OBJECT_ARG FROM INFORMATION_SCHEMA.PROCEDURES WHERE PROCEDURE_SCHEMA='" + example.getSchema().getName() + "' AND PROCEDURE_NAME='" + example.getName() + "'";
    }
}

