/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.visitor;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class ModifyChangeSetLabelsVisitor
implements ChangeSetVisitor {
    private final String setAsLabels;
    private final boolean forceReplace;

    public ModifyChangeSetLabelsVisitor(String setAsLabels, boolean forceReplace) {
        this.setAsLabels = setAsLabels;
        this.forceReplace = forceReplace;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        Set currentValueSet = changeSet.getLabels().getLabels();
        Labels currentValue = new Labels((Collection)currentValueSet);
        if (this.forceReplace) {
            if (!currentValue.toString().equalsIgnoreCase(this.setAsLabels)) {
                Scope.getCurrentScope().getLog(ModifyChangeSetLabelsVisitor.class).info(String.format("Change set %s labels set to %s", changeSet, this.setAsLabels));
            }
            changeSet.setLabels(new Labels(this.setAsLabels));
        } else {
            List newLabels = StringUtil.splitAndTrim((String)this.setAsLabels, (String)",");
            newLabels.forEach(arg_0 -> ((Labels)currentValue).add(arg_0));
            if (!currentValue.toString().equalsIgnoreCase(changeSet.getLabels().toString())) {
                Scope.getCurrentScope().getLog(ModifyChangeSetLabelsVisitor.class).info(String.format("Change set %s labels set to %s", changeSet, currentValue));
            }
            changeSet.setLabels(currentValue);
        }
    }
}

