/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PreferencesStore
implements Store {
    private final Preferences prefs;
    private final String key;

    public PreferencesStore(Preferences preferences) {
        this(preferences, PreferencesStore.PREFERENCES_KEY());
    }

    public PreferencesStore(Preferences preferences, String string) {
        this.prefs = Objects.requireNonNull(preferences);
        this.key = Objects.requireNonNull(string);
    }

    @Override
    public InputStream input() throws IOException {
        return new ByteArrayInputStream(this.checkedData());
    }

    @Override
    public OutputStream output() throws IOException {
        return new ByteArrayOutputStream(8192){

            @Override
            public void close() throws IOException {
                PreferencesStore.this.data(this.toByteArray());
                PreferencesStore.this.sync();
            }
        };
    }

    @Override
    public void delete() throws IOException {
        this.checkedData();
        this.data(null);
        this.sync();
    }

    @Override
    public boolean exists() {
        return null != this.data();
    }

    private byte[] checkedData() throws FileNotFoundException {
        byte[] byArray = this.data();
        if (null == byArray) {
            throw new FileNotFoundException(PreferencesStore._string#1() + this.key + PreferencesStore._string#2() + (this.isUserNode() ? PreferencesStore._string#3() : PreferencesStore._string#4()) + PreferencesStore._string#5() + this.prefs.absolutePath() + PreferencesStore._string#6());
        }
        return byArray;
    }

    @Nullable
    public byte[] data() {
        return this.prefs.getByteArray(this.key, null);
    }

    public void data(@CheckForNull byte[] byArray) {
        if (null != byArray) {
            this.prefs.putByteArray(this.key, byArray);
        } else {
            this.prefs.remove(this.key);
        }
    }

    public boolean isUserNode() {
        return this.prefs.isUserNode();
    }

    public void sync() throws IOException {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException);
        }
    }

    private static final /* synthetic */ String PREFERENCES_KEY() {
        return new ObfuscatedString(new long[]{-6338034052425517281L, -1707520742307695204L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{3549687354307703036L, 2394035508273620563L, 7653938358067556869L, 283006979103268802L}).toString();
    }

    private static /* synthetic */ String _string#2() {
        return new ObfuscatedString(new long[]{182482914976390222L, 4068628026647893871L, -1762427726578404879L}).toString();
    }

    private static /* synthetic */ String _string#3() {
        return new ObfuscatedString(new long[]{-5547881465039634048L, 2530571765488775042L}).toString();
    }

    private static /* synthetic */ String _string#4() {
        return new ObfuscatedString(new long[]{-4146629318129871040L, -2682321872312039099L}).toString();
    }

    private static /* synthetic */ String _string#5() {
        return new ObfuscatedString(new long[]{-3536907192848370077L, 2387377480188118170L, 2601041178948627204L, -3974839686390976051L, -5579932102082915725L, -8382819339605991028L, 7915125369018662354L}).toString();
    }

    private static /* synthetic */ String _string#6() {
        return new ObfuscatedString(new long[]{-889465107125644564L, -8555546914023288083L}).toString();
    }
}

