/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;

public class DeploymentIdFilter
implements ChangeSetFilter {
    private String commandName;
    private Map<String, ChangeSet> deployedChangeSets = new LinkedHashMap<String, ChangeSet>();
    private Map<String, ChangeSet> noInverseChangeSets = new LinkedHashMap<String, ChangeSet>();

    public DeploymentIdFilter(String deploymentId, Database database, List<RanChangeSet> ranChangeSets, DatabaseChangeLog changelog, String commandName) throws LiquibaseException {
        this.commandName = commandName;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (ranChangeSet.getDeploymentId() == null || !ranChangeSet.getDeploymentId().equals(deploymentId) || RollbackOneUpdateCommandStep.matchesTagChange(ranChangeSet, database)) continue;
            boolean allInversesFound = true;
            ChangeSet changeSet = changelog.getChangeSet(ranChangeSet.getChangeLog(), ranChangeSet.getAuthor(), ranChangeSet.getId());
            if (changeSet == null) {
                String message = this.createNotFoundErrorMessage(changelog, ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog());
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                throw new LiquibaseException(message);
            }
            if (changeSet.getRollback().getChanges().size() == 0) {
                List changes = changeSet.getChanges();
                for (Change change : changes) {
                    if (change.supportsRollback(database)) continue;
                    this.noInverseChangeSets.put(changeSet.toString(), changeSet);
                    allInversesFound = false;
                    break;
                }
            }
            if (!allInversesFound) continue;
            this.deployedChangeSets.put(changeSet.toString(), changeSet);
        }
    }

    private String createNotFoundErrorMessage(DatabaseChangeLog changeLog, String id, String author, String path) {
        List changeSets = changeLog.getChangeSets();
        String prefix = "\nWARNING: The command '" + this.commandName + "' failed because the changeset targeted by '" + id + "::" + author + "::" + path + "'\ncannot be located.  ";
        for (ChangeSet changeSet : changeSets) {
            if (!DatabaseChangeLog.normalizePath((String)changeSet.getFilePath()).equalsIgnoreCase(DatabaseChangeLog.normalizePath((String)path))) {
                return prefix + "The path '" + changeSet.getFilePath() + "' does not resolve to the desired changelog. One solution may be to control the lookup path of\nyour changeLogFile by adding it's base directory to the --classpath flag and removing any relative path information from the --changeLogFile flag.";
            }
            if (!changeSet.getAuthor().equalsIgnoreCase(author)) {
                return prefix + "The changelog author '" + changeSet.getAuthor() + "' does not match the changeset author '" + author + "'";
            }
            if (!changeSet.getId().equalsIgnoreCase(id)) {
                return prefix + "The changelog ID '" + changeSet.getId() + "' does not match the changeset ID '" + id + "'";
            }
            if (changeLog.isDbmsMatch(changeSet.getDbmsSet())) continue;
            String dbmsString = changeLog.getChangeLogParameters().getValue("database.typeName", changeLog).toString();
            return prefix + "The changelog DBMS: '" + dbmsString + "'  does not match the changeset DBMS '" + changeSet.getDbmsSet().toString() + "'";
        }
        if (changeSets.isEmpty()) {
            return prefix + "There are no changesets associated with this changelog";
        }
        return "";
    }

    public Map<String, ChangeSet> getNoInverseChangeSets() {
        return this.noInverseChangeSets;
    }

    public boolean isEmpty() {
        return this.deployedChangeSets.isEmpty();
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String changeSetString = changeSet.toString();
        if (this.deployedChangeSets.containsKey(changeSetString)) {
            return new ChangeSetFilterResult(true, "Changeset to rollback is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, "Changeset " + changeSetString + " will not rollback", this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

