/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtil;
import lombok.Generated;

public enum DatabaseChangeLogHistoryColumns {
    ID("ID", "id", false, false),
    AUTHOR("AUTHOR", "author", false, false),
    FILENAME("FILENAME", "filename", false, false),
    COMMAND("COMMAND", "command", false, false),
    INTERNAL_COMMAND("INTERNAL_COMMAND", "internalCommand", false, false),
    ARGUMENTS("ARGUMENTS", "arguments", false, false),
    OUTCOME("OUTCOME", "outcome", false, false),
    START("START", "start", false, true),
    END("END", "end", false, true),
    TAG("TAG", "tag", false, false),
    CONTEXTS("CONTEXTS", "contexts", false, false),
    LABELS("LABELS", "labels", false, false),
    MD5SUM("MD5SUM", "md5Sum", false, false),
    DESCRIPTION("DESCRIPTION", "description", false, false),
    COMMENTS("COMMENTS", "comments", false, false),
    DEPLOYMENT_ID("DEPLOYMENT_ID", "deploymentId", false, false),
    EXECUTEDSQL("EXECUTEDSQL", "executedSql", true, false),
    LIQUIBASEVERSION("LIQUIBASEVERSION", "liquibaseVersion", false, false),
    HOSTNAME("HOSTNAME", "hostname", false, false),
    SYSTEMUSER("SYSTEMUSER", "systemUser", false, false),
    INTERFACE("INTERFACE", "iinterface", false, false),
    EXTENSIONS("EXTENSIONS", "extensions", true, false);

    private final String columnName;
    private final String pojoFieldName;
    private final boolean verboseColumn;
    private final boolean isDate;

    public static List<DatabaseChangeLogHistoryEntry> fromResultSet(List<Map<String, ?>> resultSet, Boolean verbose) {
        ArrayList<DatabaseChangeLogHistoryEntry> entries = new ArrayList<DatabaseChangeLogHistoryEntry>(resultSet.size());
        for (Map<String, ?> result : resultSet) {
            DatabaseChangeLogHistoryEntry entry = new DatabaseChangeLogHistoryEntry();
            for (DatabaseChangeLogHistoryColumns column : DatabaseChangeLogHistoryColumns.values()) {
                Object columnValue = result.get(column.getColumnName());
                try {
                    Field declaredField = entry.getClass().getDeclaredField(column.getPojoFieldName());
                    declaredField.setAccessible(true);
                    declaredField.set(entry, ObjectUtil.defaultIfNull(columnValue, null, o -> {
                        if (Boolean.FALSE.equals(verbose) && column.isVerboseColumn()) {
                            return StringUtil.limitSize((String)o.toString(), (int)500);
                        }
                        if (column.isDate()) {
                            return StandardChangeLogHistoryService.convertDate((Object)o);
                        }
                        return o.toString();
                    }));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new UnexpectedLiquibaseException((Throwable)e);
                }
            }
            entries.add(entry);
        }
        return entries;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public String getPojoFieldName() {
        return this.pojoFieldName;
    }

    @Generated
    public boolean isVerboseColumn() {
        return this.verboseColumn;
    }

    @Generated
    public boolean isDate() {
        return this.isDate;
    }

    @Generated
    private DatabaseChangeLogHistoryColumns(String columnName, String pojoFieldName, boolean verboseColumn, boolean isDate) {
        this.columnName = columnName;
        this.pojoFieldName = pojoFieldName;
        this.verboseColumn = verboseColumn;
        this.isDate = isDate;
    }
}

