/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.statement.compositetype.ChangeCompositeTypeOwnerStatement;
import java.util.Arrays;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class ChangeCompositeTypeOwnerGenerator
extends AbstractSqlGenerator<ChangeCompositeTypeOwnerStatement> {
    List<String> functions = Arrays.asList("CURRENT_ROLE", "CURRENT_USER", "SESSION_USER");

    public boolean supports(ChangeCompositeTypeOwnerStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(ChangeCompositeTypeOwnerStatement statement, Database database, SqlGeneratorChain<ChangeCompositeTypeOwnerStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getTypeName());
        validationErrors.checkRequiredField("newOwner", (Object)statement.getNewOwner());
        return validationErrors;
    }

    public Sql[] generateSql(ChangeCompositeTypeOwnerStatement statement, Database database, SqlGeneratorChain<ChangeCompositeTypeOwnerStatement> sqlGeneratorChain) {
        String owner = this.functions.contains(statement.getNewOwner().toUpperCase()) ? statement.getNewOwner() : database.escapeObjectName(statement.getNewOwner(), DatabaseObject.class);
        return new Sql[]{new UnparsedSql(String.format("ALTER TYPE %s OWNER TO %s", database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getTypeName(), CompositeType.class), owner), new DatabaseObject[0])};
    }
}

