/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.statement.compositetype.ChangeCompositeTypeSchemaStatement;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class ChangeCompositeTypeSchemaGenerator
extends AbstractSqlGenerator<ChangeCompositeTypeSchemaStatement> {
    public boolean supports(ChangeCompositeTypeSchemaStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(ChangeCompositeTypeSchemaStatement statement, Database database, SqlGeneratorChain<ChangeCompositeTypeSchemaStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getTypeName());
        validationErrors.checkRequiredField("oldSchemaName", (Object)statement.getOldSchemaName());
        validationErrors.checkRequiredField("newSchemaName", (Object)statement.getNewSchemaName());
        return validationErrors;
    }

    public Sql[] generateSql(ChangeCompositeTypeSchemaStatement statement, Database database, SqlGeneratorChain<ChangeCompositeTypeSchemaStatement> sqlGeneratorChain) {
        String newSchemaName = database.escapeObjectName(statement.getNewSchemaName(), Schema.class);
        return new Sql[]{new UnparsedSql(String.format("ALTER TYPE %s SET SCHEMA %s", database.escapeObjectName(statement.getCatalogName(), statement.getOldSchemaName(), statement.getTypeName(), Schema.class), newSchemaName), new DatabaseObject[0])};
    }
}

