/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.EnableTriggerChange;
import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;

public class ChangedTriggerChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Trigger.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        String catalogName;
        ArrayList<Object> changes = new ArrayList<Object>();
        String schemaName = null;
        if (databaseObject.getSchema() != null) {
            schemaName = databaseObject.getSchema().getName();
        }
        String scope = null;
        if (((Trigger)databaseObject).getCatalog() == null) {
            catalogName = databaseObject.getSchema() == null ? null : databaseObject.getSchema().getCatalogName();
        } else {
            catalogName = ((Trigger)databaseObject).getCatalog().getName();
            if (database2 instanceof MSSQLDatabase) {
                scope = "CATALOG";
            }
        }
        if (objectDifferences.isDifferent("body")) {
            CreateTriggerChange replaceTriggerChange = new CreateTriggerChange();
            replaceTriggerChange.setTriggerBody(this.convertToReplace(((StoredDatabaseLogic)databaseObject).getBody(), database2));
            replaceTriggerChange.setTriggerName(databaseObject.getName());
            if (diffOutputControl.getIncludeCatalog()) {
                replaceTriggerChange.setCatalogName(catalogName);
            }
            if (diffOutputControl.getIncludeSchema()) {
                replaceTriggerChange.setSchemaName(schemaName);
            }
            if (database instanceof MSSQLDatabase) {
                replaceTriggerChange.setReplaceIfExists(true);
            }
            changes.add((Object)replaceTriggerChange);
        }
        if (objectDifferences.isDifferent("disabled")) {
            if (((Trigger)databaseObject).isDisabled().booleanValue()) {
                DisableTriggerChange disableTriggerChange = new DisableTriggerChange();
                disableTriggerChange.setTriggerName(databaseObject.getName());
                disableTriggerChange.setTableName(((Trigger)databaseObject).getTableName());
                disableTriggerChange.setScope(scope);
                if (diffOutputControl.getIncludeCatalog()) {
                    disableTriggerChange.setCatalogName(catalogName);
                }
                if (diffOutputControl.getIncludeSchema()) {
                    disableTriggerChange.setSchemaName(schemaName);
                }
                changes.add((Object)disableTriggerChange);
            } else {
                EnableTriggerChange enableTriggerChange = new EnableTriggerChange();
                enableTriggerChange.setTriggerName(databaseObject.getName());
                enableTriggerChange.setTableName(((Trigger)databaseObject).getTableName());
                enableTriggerChange.setScope(scope);
                if (diffOutputControl.getIncludeCatalog()) {
                    enableTriggerChange.setCatalogName(catalogName);
                }
                if (diffOutputControl.getIncludeSchema()) {
                    enableTriggerChange.setSchemaName(schemaName);
                }
                changes.add((Object)enableTriggerChange);
            }
        }
        return AbstractMissingStoredLogicChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, changes.toArray(new Change[changes.size()]));
    }
}

