/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.ui.NoEmptyValueInputHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;

public abstract class AbstractFlowCommand
extends AbstractCommandStep {
    public void validate(CommandScope commandScope) throws CommandValidationException {
        super.validate(commandScope);
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])commandScope.getCommand().getName());
    }

    FlowFileLoad loadFlowFileContents(String flowFileArg, boolean wasDefaultFlowFileArgValueUsed, boolean skipMissingProperties, Map<String, Object> inheritedVariables) throws IOException {
        ConfiguredValue headlessValue = GlobalConfiguration.HEADLESS.getCurrentConfiguredValue();
        boolean headlessConfigValue = (Boolean)headlessValue.getValue();
        if (headlessConfigValue || !wasDefaultFlowFileArgValueUsed) {
            return FlowFileHelper.load(flowFileArg, skipMissingProperties, inheritedVariables);
        }
        try {
            return FlowFileHelper.load(flowFileArg, skipMissingProperties, inheritedVariables);
        }
        catch (FileNotFoundException e) {
            return this.createAndLoadFlowFile(flowFileArg, skipMissingProperties, inheritedVariables);
        }
    }

    private FlowFileLoad createAndLoadFlowFile(String flowFileArg, boolean skipMissingProperties, Map<String, Object> inheritedVariables) throws IOException {
        String searchPath = null;
        String newFlowFilePath = flowFileArg;
        String shouldCreateFile = (String)Scope.getCurrentScope().getUI().prompt("WARNING: No flow file detected. Would you like to create and automatically use '" + newFlowFilePath + "' ?" + System.lineSeparator() + "[1] Yes, create and use sample flow file in the Current Working Directory" + System.lineSeparator() + "[2] Yes, create and use sample flow file at a path I will specify" + System.lineSeparator() + "[3] Just create sample flow file in the CWD, do not use, and exit command" + System.lineSeparator() + "[n] No, do not create sample file, and exit command." + System.lineSeparator(), (Object)"1", (input, type) -> {
            if (input == null || !input.equalsIgnoreCase("1") && !input.equalsIgnoreCase("2") && !input.equalsIgnoreCase("3") && !input.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return input;
        }, String.class);
        if (shouldCreateFile.equalsIgnoreCase("n")) {
            String message = "No flow-file available. Set the 'flow-file' property with a CLI argument, Environment variable, or other standard method. Learn more at https://docs.liquibase.com/commands/flow/flow.html";
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning(message);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            return null;
        }
        if (shouldCreateFile.equals("3")) {
            String newFlowFile = FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml", newFlowFilePath);
            String message = "Sample '" + newFlowFile + "' file created, and ready to use. Learn more at https://docs.liquibase.com/commands/flow/flow.html";
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning(message);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            return null;
        }
        if (shouldCreateFile.equals("2")) {
            String path = (String)Scope.getCurrentScope().getUI().prompt("Please enter a relative or absolute, local or remote path. Do not provide a filename. To use a remote path, such as \"s3://<mybucket>\" or \"az://<mycontainer>\", please install the correct extension. Learn more about remote path options at http://docs.liquibase.com/remote-files.", null, new NoEmptyValueInputHandler(), String.class);
            newFlowFilePath = FlowFileHelper.createDefaultFlowFileAtPath("liquibase.flowfile.yaml", path);
        } else {
            searchPath = ".";
            newFlowFilePath = FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml", newFlowFilePath);
        }
        if (searchPath == null) {
            return FlowFileHelper.load(newFlowFilePath, skipMissingProperties, inheritedVariables);
        }
        SearchPathResourceAccessor resourceAccessor = new SearchPathResourceAccessor(".", new ResourceAccessor[]{Scope.getCurrentScope().getResourceAccessor()});
        String finalNewFlowFilePath = newFlowFilePath;
        try {
            return (FlowFileLoad)Scope.child(Collections.singletonMap(Scope.Attr.resourceAccessor.name(), resourceAccessor), () -> FlowFileHelper.load(finalNewFlowFilePath, skipMissingProperties, inheritedVariables));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

