/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProSnakeYamlUtil;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.nodes.Tag;

public class InitPropertiesCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "properties"};
    public static final CommandArgumentDefinition<String> REPORT_PATH;
    public static final CommandArgumentDefinition<Boolean> REPORT_ENABLED;

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        this.extractGlobalArguments(results);
        this.extractCommandArguments(commandScope, results);
        String report = this.toYaml(results);
        this.writeReport(resultsBuilder, commandScope, report);
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    private void writeReport(CommandResultsBuilder resultsBuilder, CommandScope commandScope, String report) throws IOException {
        if (Boolean.FALSE.equals(commandScope.getArgumentValue(REPORT_ENABLED))) {
            this.handleOutput(resultsBuilder, report);
            return;
        }
        String reportPath = (String)commandScope.getArgumentValue(REPORT_PATH);
        if (StringUtils.isEmpty((CharSequence)reportPath)) {
            reportPath = "./";
        } else if (!reportPath.endsWith(File.separator)) {
            reportPath = reportPath + File.separator;
        }
        String path = String.format("%sinit-properties-report-%s.yaml", reportPath, LocalDateTime.now().toString().replace(":", "-"));
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        try (OutputStream outputStream = pathHandlerFactory.openResourceOutputStream(path, new OpenOptions().setCreateIfNeeded(true));){
            outputStream.write(report.getBytes());
        }
        Scope.getCurrentScope().getUI().sendMessage("Report written to " + path);
    }

    private void extractGlobalArguments(Map<String, Object> results) {
        ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getRegisteredDefinitions(false).forEach(definition -> {
            if (definition.getCurrentConfiguredValue() != null && !definition.getCurrentConfiguredValue().wasDefaultValueUsed() && definition.getCurrentConfiguredValue().getValue() != null) {
                LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
                results.put(definition.getKey(), report);
                report.put("value", definition.getCurrentConfiguredValue().getValueObfuscated().toString());
                InitPropertiesCommandStep.extractOverridesInformation(definition, definition.getCurrentConfiguredValue().getProvidedValues(), report);
            }
        });
    }

    private static void extractOverridesInformation(ConfigurationDefinition<?> definition, List<ProvidedValue> providedValues, Map<String, Object> report) {
        int level = 1;
        for (ProvidedValue providedValue : providedValues) {
            if (providedValue.getProvider().getPrecedence() == -1 && providedValues.size() > 1) continue;
            if (level > 1) {
                LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
                report.put("overrides", overrides);
                overrides.put("value", definition != null && definition.getCurrentValue().equals(definition.getCurrentValueObfuscated()) ? providedValue.getValue().toString() : "*****");
                report = overrides;
            }
            String description = providedValue.getProvider().toString().split("@")[0];
            if (providedValue.getProvider() instanceof AbstractMapConfigurationValueProvider) {
                description = ((AbstractMapConfigurationValueProvider)providedValue.getProvider()).getDescription();
            }
            report.put("location", description);
            ++level;
        }
    }

    private void extractCommandArguments(CommandScope commandScope, Map<String, Object> results) {
        SortedSet commands = ((CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class)).getCommands(false);
        for (CommandDefinition commandDef : commands) {
            SortedMap arguments = commandDef.getArguments();
            for (CommandArgumentDefinition argument : arguments.values()) {
                ConfiguredValue configuredValue = commandScope.getConfiguredValue(argument);
                if (configuredValue == null || configuredValue.wasDefaultValueUsed() || configuredValue.getValue() == null) continue;
                LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
                results.put(argument.getName(), report);
                report.put("value", configuredValue.getValueObfuscated().toString());
                InitPropertiesCommandStep.extractOverridesInformation(null, configuredValue.getProvidedValues(), report);
            }
        }
    }

    private String toYaml(Map<String, Object> reports) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        dumperOptions.setPrettyFlow(true);
        Yaml yaml = new Yaml(dumperOptions);
        yaml.setBeanAccess(BeanAccess.PROPERTY);
        return ProSnakeYamlUtil.removeClassTypeMarksFromSerializedJson(yaml.dumpAs(reports, Tag.MAP, DumperOptions.FlowStyle.BLOCK));
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Generate a summary of all Liquibase properties available."));
        commandDefinition.setGroupShortDescription(new String[]{"properties"}, "Properties");
        commandDefinition.setLongDescription(ProStringUtil.markWithPro("Generate a summary of all Liquibase properties available.\n\nThis command will generate a YAML file with all the properties available in Liquibase, including their values and where they were set. This is useful for debugging and understanding how Liquibase is configured."));
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        REPORT_ENABLED = builder.argument("reportEnabled", Boolean.class).description("Enable or disable reporting.").addAlias("reportsEnabled").defaultValue((Object)false).build();
        REPORT_PATH = builder.argument("reportPath", String.class).description("The path to the directory to generate the report.").addAlias("reportsPath").build();
    }
}

