/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.util.ProStringUtil;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.ObjectUtil;

public class LiquibaseProConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<Boolean> MARK_UNUSED_NOT_DROP;
    public static final ConfigurationDefinition<Boolean> DROP_PUBLIC_SYNONYMS_KEY;
    public static final ConfigurationDefinition<Boolean> INLINE_SQL_KEY;
    public static final ConfigurationDefinition<Boolean> FORCE_ROLLBACK_ON_ERROR_PARTIAL_CHANGES;
    public static final ConfigurationDefinition<String> GLOBAL_END_DELIMITER;
    public static final ConfigurationDefinition<Boolean> GLOBAL_END_DELIMITER_PRIORITIZED;
    public static final ConfigurationDefinition<Boolean> GLOBAL_STRIP_COMMENTS;
    public static final ConfigurationDefinition<Boolean> GLOBAL_STRIP_COMMENTS_PRIORITIZED;

    protected static void checkLicense(String configName) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            throw new IllegalArgumentException(String.format("Using '%s' requires a valid Liquibase Pro or Labs license. Get a free license key at %s.", configName, "https://liquibase.com/trial"));
        }
    }

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.pro");
        MARK_UNUSED_NOT_DROP = builder.define("markUnusedNotDrop", Boolean.class).setDescription("If a column would be dropped in a diffChangeLog, call markUnused instead if set to true").setDefaultValue((Object)false).build();
        DROP_PUBLIC_SYNONYMS_KEY = builder.define("synonyms.drop.public", Boolean.class).setDescription("If false, do not drop public synonyms in diffChangeLog/dropAll").setDefaultValue((Object)true).build();
        INLINE_SQL_KEY = builder.define("sql.inline", Boolean.class).setDescription("If true, generate changeSets with SQL-based changes inlined instead of saving them to an external file").setDefaultValue((Object)false).build();
        FORCE_ROLLBACK_ON_ERROR_PARTIAL_CHANGES = builder.define("forceOnPartialChanges", Boolean.class).setDescription("If true, rollback execution will be forced when having partial changes that needs to be rolled back. Defaults to false.").setDefaultValue((Object)false).setHidden(true).build();
        GLOBAL_END_DELIMITER_PRIORITIZED = builder.define("globalEndDelimiter.prioritized", Boolean.class).setDescription(ProStringUtil.markWithPro("If true, the global end delimiter overrides all other settings")).setDefaultValue((Object)false).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String && !value.equals("")) {
                LiquibaseProConfiguration.checkLicense("global-end-delimiter-prioritized");
                return (Boolean)ObjectUtil.convert((Object)value, Boolean.class);
            }
            return null;
        }).build();
        GLOBAL_END_DELIMITER = builder.define("globalEndDelimiter", String.class).setDescription(ProStringUtil.markWithPro("The default end delimiter to use for all change sets")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String && !value.equals("")) {
                LiquibaseProConfiguration.checkLicense("global-end-delimiter");
                return (String)value;
            }
            return null;
        }).build();
        GLOBAL_STRIP_COMMENTS_PRIORITIZED = builder.define("globalStripComments.prioritized", Boolean.class).setDescription(ProStringUtil.markWithPro("If true, the global strip comments overrides all other settings")).setDefaultValue((Object)false).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("global-strip-comments-prioritized");
            return Boolean.valueOf(value.toString());
        }).build();
        GLOBAL_STRIP_COMMENTS = builder.define("globalStripComments", Boolean.class).setDescription(ProStringUtil.markWithPro("The default strip comments to use for all change sets")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("global-strip-comments");
            return Boolean.valueOf(value.toString());
        }).build();
    }
}

