/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.executor;

import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.executor.jvm.StatementCallback;
import liquibase.license.LicenseServiceUtils;
import liquibase.sql.SqlConfiguration;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import org.apache.commons.lang3.StringUtils;

public class ProJdbcExecutor
extends JdbcExecutor {
    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return super.getPriority() + 1;
        }
        return -1;
    }

    protected void showSqlWarnings(Statement stmtToUse, StatementCallback action) throws SQLException, DatabaseException {
        super.showSqlWarnings(stmtToUse, action);
        if (!((Boolean)SqlConfiguration.SHOW_SQL_WARNING_MESSAGES.getCurrentValue()).booleanValue()) {
            return;
        }
        Database database = (Database)Scope.getCurrentScope().get(Scope.Attr.database.name(), Database.class);
        if (database instanceof OracleDatabase) {
            String rawSql = action.getStatement().getFormattedStatement(database);
            ProJdbcExecutor.showOracleSqlErrors(rawSql, database);
        }
    }

    public static void showOracleSqlErrors(String rawSql, Database database) throws DatabaseException {
        AtomicBoolean firstLine = new AtomicBoolean(true);
        HashSet processedErrors = new HashSet();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        List errors = jdbcExecutor.queryForList((SqlStatement)new RawParameterizedSqlStatement("SELECT SEQUENCE, LINE, POSITION, TYPE, OWNER, NAME, TEXT FROM ALL_ERRORS ORDER BY NAME, SEQUENCE"));
        errors.stream().filter(error -> ProJdbcExecutor.shouldInclude(error, rawSql, processedErrors)).forEach(error -> {
            if (firstLine.get()) {
                Scope.getCurrentScope().getUI().sendMessage("");
                firstLine.set(false);
            }
            String message = String.format("SEQUENCE: %s LINE: %s POSITION: %s TYPE: %s NAME: %s%nTEXT: %s", error.get("SEQUENCE"), error.get("LINE"), error.get("POSITION"), error.get("TYPE"), ProJdbcExecutor.determineName(rawSql, error), error.get("TEXT"));
            Scope.getCurrentScope().getUI().sendMessage(message);
            processedErrors.add(ProJdbcExecutor.createKey(error));
        });
        database.rollback();
    }

    private static Object determineName(String rawSql, Map<String, ?> error) {
        String schema = (String)error.get("OWNER");
        schema = ObjectSqlFileUtil.findSchemaName(rawSql, (String)error.get("TYPE"));
        String name = (String)error.get("NAME");
        if (StringUtils.isEmpty((CharSequence)schema)) {
            return name;
        }
        return schema + "." + name;
    }

    private static boolean shouldInclude(Map<String, ?> error, String rawSql, Set<String> processedErrors) {
        String key = ProJdbcExecutor.createKey(error);
        return ProJdbcExecutor.containsName(rawSql, (String)error.get("TYPE"), (String)error.get("NAME"), (String)error.get("OWNER")) && !processedErrors.contains(key);
    }

    private static String createKey(Map<String, ?> error) {
        String type = (String)error.get("TYPE");
        String name = (String)error.get("NAME");
        BigDecimal sequence = (BigDecimal)error.get("SEQUENCE");
        BigDecimal line = (BigDecimal)error.get("LINE");
        BigDecimal position = (BigDecimal)error.get("POSITION");
        return String.format("%s_%s_%s_%s_%s", type, name, sequence, line, position);
    }

    private static boolean containsName(String rawSql, String type, String name, String owner) {
        try {
            String actualName = ObjectSqlFileUtil.findStoredLogicName(rawSql, type);
            if (actualName == null) {
                return false;
            }
            String schemaName = ObjectSqlFileUtil.findSchemaName(rawSql, type);
            if (schemaName == null) {
                schemaName = owner;
            }
            return StringUtils.equalsIgnoreCase((CharSequence)owner, (CharSequence)schemaName) && actualName.equalsIgnoreCase(name);
        }
        catch (Exception e) {
            return false;
        }
    }
}

