/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import com.datical.liquibase.ext.storedlogic.databasepackage.PackageBodySnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.PackageSnapshotGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.Logger;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStoredDatabaseLogicSnapshotGenerator
extends JdbcSnapshotGenerator {
    protected static final String OBJECT_NAME_FIELD = "OBJECT_NAME";
    protected static final String STATUS_FIELD = "STATUS";
    protected static final String OBJECT_BODY_FIELD = "OBJECT_BODY";
    protected static final String OBJECT_ARG_FIELD = "OBJECT_ARG";
    protected static final String OBJECT_ARG_NO_DEFAULTS_FIELD = "OBJECT_ARG_NO_DEFAULTS";
    protected static final String ORDER_FIELD = "ORDER";
    protected static final String TYPE_FIELD = "TYPE";
    protected static final String PARAMETER_NAME = "PARAMETER_NAME";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String DTD_IDENTIFIER = "DTD_IDENTIFIER";
    protected static final String PARAMETER_MODE = "PARAMETER_MODE";
    protected static final String NUMERIC_PRECISION = "NUMERIC_PRECISION";
    protected static final String NUMERIC_SCALE = "NUMERIC_SCALE";
    protected static final String CHAR_LENGTH = "CHAR_LENGTH";
    public static final String USES_QUOTED_IDENTIFIER = "usesQuotedIdentifier";
    private Class<? extends DatabaseObject> localDefaultFor;

    public AbstractStoredDatabaseLogicSnapshotGenerator(Class<? extends DatabaseObject> defaultFor, Class<? extends DatabaseObject>[] addsTo) {
        super(defaultFor, (Class[])addsTo);
        this.localDefaultFor = defaultFor;
    }

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof DB2Database || database instanceof Db2zDatabase || database instanceof SnowflakeDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase) && !database.getShortName().equalsIgnoreCase("redshift")) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) throws DatabaseException, InvalidExampleException {
        Database database = databaseSnapshot.getDatabase();
        if (!this.shouldInclude((StoredDatabaseLogic)databaseObject, database)) {
            return null;
        }
        if (((Boolean)databaseObject.getAttribute("liquibaseComplete", (Object)false)).booleanValue()) {
            databaseObject.setAttribute("liquibaseComplete", null);
            return databaseObject;
        }
        StoredDatabaseLogic storedDatabaseLogicExample = (StoredDatabaseLogic)databaseObject;
        return this.performSnapshotAndBuildStoredObject(database, storedDatabaseLogicExample);
    }

    protected StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> rs = this.castToListOfMaps(queryForList);
        StringBuilder body = new StringBuilder();
        String name = null;
        Boolean valid = null;
        for (Map<String, ?> row : rs) {
            String objectBody;
            if (name == null) {
                name = (String)row.get(OBJECT_NAME_FIELD);
            }
            if (valid == null) {
                valid = row.get(STATUS_FIELD).equals("VALID");
            }
            if ((objectBody = (String)row.get(OBJECT_BODY_FIELD)) == null && (objectBody = this.getCLRBody(storedDatabaseLogicExample, database)) == null) {
                return null;
            }
            body.append(objectBody.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        body = new StringBuilder(StringUtil.trimToEmpty((String)StringUtil.trimToEmpty((String)body.toString().replace("\r\n", "\n").replace("\r", "\n"))));
        if (database instanceof MSSQLDatabase && !StringUtil.stripComments((String)(body = new StringBuilder(StringUtil.trimToEmpty((String)body.toString()))).toString(), null).trim().toUpperCase().startsWith("CREATE")) {
            body.insert(0, "CREATE ");
        }
        if (database instanceof OracleDatabase) {
            body.insert(0, "CREATE OR REPLACE ");
        }
        StoredDatabaseLogic storedDatabaseLogic = this.createReturnObject().setSchema(storedDatabaseLogicExample.getSchema()).setName(name).setValid(valid).setBody(body.toString());
        if (!rs.isEmpty() && database instanceof MSSQLDatabase) {
            storedDatabaseLogic.setAttribute(USES_QUOTED_IDENTIFIER, rs.get(0).get("USES_QUOTED_IDENTIFIER"));
        }
        return storedDatabaseLogic;
    }

    protected boolean shouldInclude(StoredDatabaseLogic returnObject, Database database) {
        return !returnObject.getName().equalsIgnoreCase("datical_compress");
    }

    protected String getCLRBody(StoredDatabaseLogic<?> example, Database database) throws DatabaseException {
        List clrParams;
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        String fullyQualifiedName = example.getName();
        if (example.getSchema() != null) {
            fullyQualifiedName = example.getSchema().getName() + "." + fullyQualifiedName;
        }
        if ((clrParams = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement("SELECT sp.name AS [sp_name], schema_name(sp.schema_id) as schema_name, sp.type as object_type, case when amsp.object_id is null then N'''' else asmblsp.name end AS [AssemblyName], case when amsp.object_id is null then N'''' else amsp.assembly_class end AS [ClassName], case when amsp.object_id is null then N'''' else amsp.assembly_method end AS [MethodName], param.name AS [name], param.parameter_id AS [param_id], sp.object_id AS [object_id], usrt.name AS [data_type], sparam.name AS [data_type_schema], ISNULL(baset.name, N'''') AS [system_type], CAST(CASE WHEN baset.name IN (N'nchar', N'nvarchar') AND param.max_length <> -1 THEN param.max_length/2 ELSE param.max_length END AS int) AS [length], CAST(param.precision AS int) AS [numeric_precision], CAST(param.scale AS int) AS [numeric_scale], param.is_output as [is_output] FROM sys.all_objects AS sp LEFT OUTER JOIN sys.all_parameters AS param ON param.object_id=sp.object_id LEFT OUTER JOIN sys.assembly_modules AS amsp ON amsp.object_id = sp.object_id LEFT OUTER JOIN sys.assemblies AS asmblsp ON asmblsp.assembly_id = amsp.assembly_id LEFT OUTER JOIN sys.procedures AS spp ON spp.object_id = sp.object_id LEFT OUTER JOIN sys.types AS usrt ON usrt.user_type_id = param.user_type_id LEFT OUTER JOIN sys.schemas AS sparam ON sparam.schema_id = usrt.schema_id LEFT OUTER JOIN sys.types AS baset ON (baset.user_type_id = param.system_type_id and baset.user_type_id = baset.system_type_id) WHERE sp.object_id=object_id('?')", new Object[]{fullyQualifiedName}))).isEmpty()) {
            log.severe("Omitting " + this.getObjectType(database).toLowerCase() + " '" + example.getName() + "': OBJECT_BODY is null. Null OBJECT_BODY values are often due to permission issues");
            return null;
        }
        String body = this.getStoredLogicBody(example, database, clrParams, log);
        return body;
    }

    private String getStoredLogicBody(StoredDatabaseLogic<?> example, Database database, List<Map<String, ?>> clrParams, Logger log) throws DatabaseException {
        String objectType;
        List functionTableColumns = null;
        Map<String, ?> clrObject = clrParams.get(0);
        String body = "CREATE ";
        switch (objectType = ((String)clrObject.get("OBJECT_TYPE")).trim()) {
            case "AF": 
            case "FS": 
            case "FT": 
            case "IF": {
                body = body + "FUNCTION ";
                if (!objectType.equals("FT")) break;
                String sql = "SELECT COLUMN_NAME, IS_NULLABLE, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION FROM INFORMATION_SCHEMA.ROUTINE_COLUMNS WHERE TABLE_NAME = ?";
                if (example.getSchema() != null && example.getSchema().getName() != null) {
                    sql = sql + " AND TABLE_SCHEMA=?";
                    functionTableColumns = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement(sql, new Object[]{database.escapeStringForDatabase(example.getName()), database.escapeStringForDatabase(example.getSchema().getName())}));
                    break;
                }
                functionTableColumns = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement(sql, new Object[]{database.escapeStringForDatabase(example.getName())}));
                break;
            }
            case "PC": {
                body = body + "PROCEDURE ";
                break;
            }
            case "P": {
                log.warning("Cannot read encrypted procedure body for '" + example.getName() + "'");
                return null;
            }
            default: {
                log.warning("Unknown CLR procedure type: " + objectType);
                return null;
            }
        }
        body = body + this.alwaysQuoteDatabaseObject(null, (String)clrObject.get("SCHEMA_NAME"), (String)clrObject.get("SP_NAME"), StoredDatabaseLogic.class, database);
        Map<String, ?> outParam = null;
        ArrayList inParams = new ArrayList();
        outParam = AbstractStoredDatabaseLogicSnapshotGenerator.getParameters(database, clrParams, outParam, inParams);
        String dataTypeString = StringUtil.join(inParams, (String)", ", AbstractStoredDatabaseLogicSnapshotGenerator::getDataTypeString);
        if (StringUtils.isNotEmpty((CharSequence)dataTypeString)) {
            body = body + "(";
            body = body + dataTypeString;
            body = body + ")";
        }
        if (outParam != null) {
            Object dataType = outParam.get(DATA_TYPE);
            if (dataType != null) {
                body = body + " RETURNS " + dataType;
            }
        } else if (functionTableColumns != null) {
            for (Map column : functionTableColumns) {
                String finalType;
                DataType dataType = new DataType(database.escapeDataTypeName((String)column.get(DATA_TYPE)));
                dataType.setColumnSize((Integer)column.get("CHARACTER_MAXIMUM_LENGTH"));
                Number numericPrecision = (Number)column.get(NUMERIC_PRECISION);
                if (numericPrecision != null) {
                    dataType.setDecimalDigits(Integer.valueOf(numericPrecision.intValue()));
                }
                if ((finalType = DataTypeFactory.getInstance().from(dataType, database).toDatabaseDataType(database).toSql()).equalsIgnoreCase("NVARCHAR(-1)")) {
                    finalType = "NVARCHAR(MAX)";
                }
                column.put("FINAL_DATA_TYPE", finalType);
            }
            body = body + " RETURNS TABLE (" + StringUtil.join((Collection)functionTableColumns, (String)", ", param -> this.alwaysQuoteDatabaseObject(null, null, (String)param.get("COLUMN_NAME"), Column.class, database) + " " + param.get("FINAL_DATA_TYPE") + " " + (param.get("IS_NULLABLE").equals("YES") ? "NULL" : " NOT NULL")) + ")";
        }
        body = body + " AS EXTERNAL NAME " + this.alwaysQuoteDatabaseObject((String)clrObject.get("ASSEMBLYNAME"), (String)clrObject.get("CLASSNAME"), (String)clrObject.get("METHODNAME"), StoredDatabaseLogic.class, database);
        return body;
    }

    private static String getDataTypeString(Map param) {
        Object paramName = param.get("NAME");
        if (paramName == null) {
            return null;
        }
        return paramName + " " + param.get("FINAL_DATA_TYPE") + ((Boolean)param.get("IS_OUTPUT") != false ? " OUTPUT" : "");
    }

    private static Map<String, ?> getParameters(Database database, List<Map<String, ?>> clrParams, Map<String, ?> outParam, List<Map<String, ?>> inParams) {
        for (Map<String, ?> param : clrParams) {
            String paramName = (String)param.get("NAME");
            if (StringUtils.trimToNull((String)paramName) == null) {
                outParam = param;
            } else {
                inParams.add(param);
            }
            DataType dataType = new DataType((String)param.get(DATA_TYPE));
            dataType.setColumnSize((Integer)param.get("LENGTH"));
            dataType.setDecimalDigits((Integer)param.get("SCALE"));
            LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(dataType, database);
            if (liquibaseDataType == null) continue;
            String finalType = liquibaseDataType.toDatabaseDataType(database).toSql();
            if (finalType.equalsIgnoreCase("NVARCHAR(-1)")) {
                finalType = "NVARCHAR(MAX)";
            }
            param.put("FINAL_DATA_TYPE", finalType);
        }
        return outParam;
    }

    protected List<Map<String, ?>> castToListOfMaps(Object genericList) {
        return (List)genericList;
    }

    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> example, Database database) throws DatabaseException {
        int majorVersion = 0;
        try {
            majorVersion = database.getDatabaseMajorVersion();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (database instanceof OracleDatabase || majorVersion >= 10 && database instanceof DB2Database) {
            String sql = "select OBJECT_NAME, STATUS, TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source." + (database instanceof DB2Database ? "schema" : "owner") + "=all_objects." + (database instanceof OracleDatabase ? "owner " : "object_schema ") + "where object_type='" + this.getObjectType(database) + "' and object_name='" + database.correctObjectName(example.getName(), StoredDatabaseLogic.class) + "' and all_objects." + (database instanceof DB2Database ? "object_schema" : "owner") + "='" + database.correctObjectName(example.getSchema().getCatalogName(), Catalog.class) + "'";
            if (database instanceof OracleDatabase) {
                sql = sql + " order by ALL_SOURCE.LINE";
            }
            return sql;
        }
        if (database instanceof DB2Database) {
            String sqlType;
            String type = this.getObjectType(database).toLowerCase();
            if (type.equals("function")) {
                sqlType = "F";
            } else if (type.equals("procedure")) {
                sqlType = "P";
            } else {
                throw new UnexpectedLiquibaseException("Unknown type: " + type);
            }
            return "select routinename from syscat.routines where routinetype = '" + sqlType + "' and routineschema='" + database.correctObjectName(example.getSchema().getCatalogName(), Catalog.class) + "'";
        }
        if (database instanceof MSSQLDatabase) {
            String fullyQualifiedName = example.getName();
            if (example.getSchema() != null) {
                fullyQualifiedName = example.getSchema().getName() + "." + fullyQualifiedName;
            }
            return "select ROUTINE_CATALOG AS OBJECT_CATALOG, ROUTINE_SCHEMA AS OBJECT_SCHEMA, ROUTINE_NAME AS OBJECT_NAME, sql_modules.definition AS OBJECT_BODY, 'VALID' as STATUS, uses_quoted_identifier FROM " + database.escapeTableName(example.getSchema().getCatalogName(), "information_schema", "routines") + " LEFT OUTER JOIN sys.sql_modules on object_id=object_id('" + fullyQualifiedName + "') where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + example.getSchema().getName() + "' AND ROUTINE_NAME='" + example.getName() + "' ";
        }
        if (database instanceof EnterpriseDBDatabase) {
            String sql = "select OBJECT_NAME, STATUS, ALL_SOURCE.TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and object_name='" + database.correctObjectName(example.getName(), StoredDatabaseLogic.class) + "' and all_objects.schema_name ='" + database.correctObjectName(example.getSchema().getName().toUpperCase(), Catalog.class) + "'";
            return sql;
        }
        throw new UnexpectedLiquibaseException("Unsupported database type: " + database.getShortName());
    }

    protected String getAddToSql(Schema schema, Database database) throws DatabaseException {
        if (database instanceof OracleDatabase) {
            return "select OBJECT_NAME, STATUS, TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and all_objects.owner='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' order by ALL_SOURCE.LINE";
        }
        if (database instanceof DB2Database) {
            String sqlType;
            try {
                if (database.getDatabaseMajorVersion() >= 10) {
                    return "select object_name from all_objects where object_type='" + this.getObjectType(database) + "' and object_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            String type = this.getObjectType(database).toLowerCase();
            if (type.equals("function")) {
                sqlType = "F";
            } else if (type.equals("procedure")) {
                sqlType = "P";
            } else {
                throw new UnexpectedLiquibaseException("Unknown type: " + type);
            }
            return "select routinename from syscat.routines where routinetype = '" + sqlType + "' and routine_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
        }
        if (database instanceof MySQLDatabase) {
            return "select ROUTINE_NAME AS OBJECT_NAME FROM information_schema.routines where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + schema.getCatalogName() + "' ";
        }
        if (database instanceof MSSQLDatabase) {
            return "select ROUTINE_CATALOG AS OBJECT_CATALOG, ROUTINE_SCHEMA AS OBJECT_SCHEMA, ROUTINE_NAME AS OBJECT_NAME, sql_modules.definition AS OBJECT_BODY, 'VALID' as STATUS, uses_quoted_identifier FROM " + database.escapeTableName(schema.getCatalogName(), "INFORMATION_SCHEMA", "ROUTINES") + " LEFT OUTER JOIN sys.sql_modules on object_name(object_id)=SPECIFIC_NAME AND object_schema_name(object_id)=SPECIFIC_SCHEMA where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + schema.getName() + "'";
        }
        if (database instanceof EnterpriseDBDatabase) {
            return "select OBJECT_NAME, STATUS from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and all_objects.schema_name='" + schema.getName().toUpperCase() + "' order by ALL_SOURCE.LINE";
        }
        throw new UnexpectedLiquibaseException("Unsupported database type: " + database.getShortName() + " for " + ((Object)((Object)this)).getClass().getName());
    }

    protected abstract String getObjectType(Database var1);

    protected abstract StoredDatabaseLogic<?> createReturnObject();

    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)databaseObject;
        Database database = databaseSnapshot.getDatabase();
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        Boolean valid = null;
        List<Map<String, ?>> rs = this.queryForList(databaseSnapshot, schema, executor);
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase) {
            HashMap<String, StoredDatabaseLogic> objectByName = new HashMap<String, StoredDatabaseLogic>();
            for (Map<String, ?> row : rs) {
                String name = (String)row.get(OBJECT_NAME_FIELD);
                valid = AbstractStoredDatabaseLogicSnapshotGenerator.determineValidity(row, database, valid);
                String objectBody = (String)row.get(OBJECT_BODY_FIELD);
                this.setupObject(row, objectByName, name, schema, valid, objectBody, database);
            }
            for (StoredDatabaseLogic obj : objectByName.values()) {
                if (StringUtil.trimToNull((String)obj.getBody()) != null) {
                    String upperCase;
                    if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
                        obj.setBody("CREATE OR REPLACE " + StringUtil.trimToEmpty((String)StringUtil.trimToEmpty((String)obj.getBody().replace("\r\n", "\n").replace("\r", "\n"))));
                    } else if (database instanceof MSSQLDatabase && !(upperCase = StringUtil.stripComments((String)obj.getBody()).trim().toUpperCase()).startsWith("CREATE") && !upperCase.startsWith(";\nCREATE")) {
                        obj.setBody("CREATE " + StringUtil.trimToEmpty((String)obj.getBody()));
                    }
                    obj.setAttribute("liquibaseComplete", (Object)true);
                }
                schema.addDatabaseObject((DatabaseObject)obj);
            }
        } else {
            for (Map<String, ?> row : rs) {
                StoredDatabaseLogic object = this.createReturnObject().setName((String)row.get(OBJECT_NAME_FIELD)).setSchema(schema);
                if (database.isSystemObject((DatabaseObject)object)) continue;
                schema.addDatabaseObject((DatabaseObject)object);
            }
        }
    }

    private void setupObject(Map<String, ?> row, Map<String, StoredDatabaseLogic> objectByName, String name, Schema schema, Boolean valid, String objectBody, Database database) {
        StoredDatabaseLogic object = objectByName.get(name);
        if (object == null) {
            object = this.createReturnObject().setSchema(schema).setName(name).setValid(valid).setBody(objectBody);
            if (database instanceof MSSQLDatabase) {
                object.setAttribute(USES_QUOTED_IDENTIFIER, row.get("USES_QUOTED_IDENTIFIER"));
            }
            objectByName.put(name, object);
        } else {
            object.setBody(object.getBody() + objectBody.replaceFirst("\\r?\\n$", "") + "\n");
        }
    }

    private static Boolean determineValidity(Map<String, ?> row, Database database, Boolean valid) {
        if (database instanceof OracleDatabase) {
            valid = row.get(STATUS_FIELD).equals("VALID");
        } else if (valid == null) {
            valid = row.get(STATUS_FIELD).equals("VALID");
        }
        return valid;
    }

    protected List<Map<String, ?>> queryForList(DatabaseSnapshot databaseSnapshot, Schema schema, Executor executor) throws DatabaseException {
        try {
            List alist = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(this.getAddToSql(schema, databaseSnapshot.getDatabase())));
            return alist;
        }
        catch (DatabaseException e) {
            if (databaseSnapshot.getDatabase() instanceof DB2Database && (this instanceof PackageSnapshotGenerator || this instanceof PackageBodySnapshotGenerator)) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error querying PACKAGE and/or PACKAGE BODY. Assuming Oracle compatibility not enabled: " + e.getMessage());
                return new ArrayList();
            }
            throw e;
        }
    }

    protected String alwaysQuoteDatabaseObject(String catalogName, String schemaName, String objectName, Class<? extends DatabaseObject> type, Database database) {
        if (objectName == null) {
            return null;
        }
        if (!(database instanceof AbstractJdbcDatabase)) {
            return database.escapeObjectName(catalogName, schemaName, objectName, type);
        }
        String returnName = ((AbstractJdbcDatabase)database).quoteObject(objectName, type);
        if (schemaName == null) {
            return returnName;
        }
        returnName = ((AbstractJdbcDatabase)database).quoteObject(schemaName, Schema.class) + "." + returnName;
        if (catalogName == null) {
            return returnName;
        }
        return ((AbstractJdbcDatabase)database).quoteObject(catalogName, Catalog.class) + "." + returnName;
    }
}

