/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools.jcl;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.jcl.JclRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.exception.DatabaseException;
import liquibase.sql.visitor.SqlVisitor;

public class JclExecutor
extends AbstractNativeToolExecutor {
    private String sourceJcl;

    public JclExecutor() {
        super("jcl");
    }

    public String getName() {
        return "jcl";
    }

    public int getPriority() {
        return 101;
    }

    public void execute(Change change, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (change instanceof AbstractSQLChange) {
            this.sourceJcl = ((AbstractSQLChange)change).getSql();
        }
        Scope.getCurrentScope().getLog(JclExecutor.class).info("Executing with the '" + this.getName() + "' executor");
        try {
            JclRunner runner = new JclRunner(this.changeSet, this.sourceJcl);
            runner.executeCommand(this.database);
            String successMessage = String.format("Success! Changeset '%s' by '%s' deployed by JCL", this.changeSet.getId(), this.changeSet.getAuthor());
            Scope.getCurrentScope().getLog(JclExecutor.class).info(successMessage);
        }
        catch (Exception e) {
            String errorMessage = String.format("%nChangeset '%s' by '%s' failed to deploy with 'jcl'. Please check the JCL logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            Scope.getCurrentScope().getLog(JclExecutor.class).severe(errorMessage);
            throw new DatabaseException((Throwable)e);
        }
    }
}

