/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools.jcl;

import com.datical.liquibase.ext.config.JclConfiguration;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.jcl.JclJob;
import com.datical.liquibase.ext.tools.jcl.JclJobOutput;
import com.datical.liquibase.ext.tools.jcl.JclJobWorker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.servicelocator.LiquibaseService;
import liquibase.util.StreamUtil;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

@LiquibaseService(skip=true)
public class JclRunner
extends NativeExecutorRunner {
    private String logFile;
    private String sourceJcl;

    public JclRunner() {
    }

    @Override
    public String getIntegrationDisplayName() {
        return "jcl";
    }

    public JclRunner(ChangeSet changeSet, String sourceJcl) {
        this.changeSet = changeSet;
        this.sourceJcl = sourceJcl;
    }

    public void executeCommand(Database database) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.sourceJcl)) {
            return;
        }
        List<String> lines = Arrays.asList(this.sourceJcl.split(System.lineSeparator()));
        String submittingMessage = String.format("Submitting job %s", lines.get(0));
        Scope.getCurrentScope().getUI().sendMessage(submittingMessage);
        JclJobWorker jobWorker = new JclJobWorker(database);
        JclJob jclJob = jobWorker.submit(lines, this.getUserName(database.getConnection()), this.getPassword(database.getConnection()));
        String jobId = jclJob.getId();
        String submittedMessage = String.format("Job %s submitted", jobId);
        Scope.getCurrentScope().getUI().sendMessage(submittedMessage);
        String waitingMessage = String.format("Waiting for job %s to complete", jobId);
        Scope.getCurrentScope().getUI().sendMessage(waitingMessage);
        jclJob.waitUntilFinished(1000L, this.getUserName(database.getConnection()), this.getPassword(database.getConnection()));
        String completedMessage = String.format("Job %s complete", jobId);
        Scope.getCurrentScope().getUI().sendMessage(completedMessage);
        String readingMessage = String.format("Reading job %s output", jobId);
        Scope.getCurrentScope().getUI().sendMessage(readingMessage);
        List<JclJobOutput> jobOutput = jobWorker.retrieveOutput(jobId, this.getUserName(database.getConnection()), this.getPassword(database.getConnection()));
        jobOutput.forEach(outputLine -> Scope.getCurrentScope().getLog(JclRunner.class).info(outputLine.getText().trim()));
        if (Boolean.TRUE == JclConfiguration.CREATE_LOG_FILE.getCurrentValue()) {
            this.writeLogFile(jobOutput);
        }
        this.parseOutputForError(jclJob, jobOutput);
    }

    private void writeLogFile(List<JclJobOutput> jobOutput) throws IOException {
        String logFilePath = (String)JclConfiguration.LOG_FILE_PATH.getCurrentValue();
        if (logFilePath == null) {
            logFilePath = FileUtils.getTempDirectoryPath();
        }
        if (logFilePath.endsWith(File.separator)) {
            logFilePath = logFilePath.substring(0, logFilePath.length() - 1);
        }
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        String fullPath = String.format("%s/%s-%s.log", logFilePath, this.changeSet.getId(), this.changeSet.getAuthor());
        StringBuilder contents = new StringBuilder(JclRunner.getExistingContents(pathHandlerFactory, fullPath));
        OpenOptions openOptions = new OpenOptions();
        try (OutputStream outputStream = pathHandlerFactory.openResourceOutputStream(fullPath, openOptions);){
            if (contents.length() > 0) {
                int length = JclRunner.longestLineInOutput(jobOutput);
                for (int i = 0; i < length; ++i) {
                    contents.append("#");
                }
                contents.append(System.lineSeparator());
                outputStream.write(contents.toString().getBytes());
            }
            for (JclJobOutput outputLine : jobOutput) {
                String output = String.format("%-8d %s%n", outputLine.getRowNum(), outputLine.getText());
                outputStream.write(output.getBytes());
            }
        }
        Scope.getCurrentScope().getUI().sendMessage(String.format("JCL log file written to '%s'", fullPath));
    }

    private static int longestLineInOutput(List<JclJobOutput> jobOutput) {
        int longest = 0;
        for (JclJobOutput outputLine : jobOutput) {
            if (outputLine.getText().length() <= longest) continue;
            longest = outputLine.getText().length();
        }
        return longest;
    }

    private static String getExistingContents(PathHandlerFactory pathHandlerFactory, String fullPath) throws IOException {
        boolean append;
        Resource resource = pathHandlerFactory.getResource(fullPath);
        String contents = "";
        boolean bl = append = (Boolean)JclConfiguration.OVERWRITE_LOG_FILE.getCurrentValue() == false;
        if (resource.exists() && append) {
            try (InputStream inputStream = resource.openInputStream();){
                contents = StreamUtil.readStreamAsString((InputStream)inputStream);
            }
        }
        return contents;
    }

    private void parseOutputForError(JclJob jobJCL, List<JclJobOutput> jobOutput) throws LiquibaseException {
        int minimumErrorCode = (Integer)JclConfiguration.MINIMUM_ERROR_RETURN_CODE.getCurrentValue();
        String jobId = jobJCL.getId();
        for (JclJobOutput jclJobOutput : jobOutput) {
            String line = jclJobOutput.getText();
            String successPatternString = ".*?" + jobId + ".*?ENDED - RC=([0-9]+)";
            String jobFailedPatternString = ".*?" + jobId + "(.*? - JCL ERROR .*)";
            Pattern pattern = Pattern.compile(successPatternString);
            Pattern errorPattern = Pattern.compile(jobFailedPatternString);
            Matcher matcher = pattern.matcher(line.trim());
            Matcher errorMatcher = errorPattern.matcher(line.trim());
            if (matcher.matches()) {
                int rc;
                String matchedRC = matcher.group(1);
                try {
                    rc = Integer.parseInt(matchedRC);
                }
                catch (NumberFormatException nfe) {
                    Scope.getCurrentScope().getLog(JclRunner.class).warning(String.format("Unable to parse condition code from %s.", matchedRC));
                    break;
                }
                if (rc == 0) {
                    Scope.getCurrentScope().getUI().sendMessage(String.format("Job %s ended successfully", jobId));
                    break;
                }
                if (rc > minimumErrorCode) {
                    String conditionCodes = this.parseOutputForConditionCodes(jobJCL, jobOutput);
                    throw new LiquibaseException(String.format("Job %s ended in error %s%n%s", jobId, matchedRC, conditionCodes));
                }
                String conditionCodes = this.parseOutputForConditionCodes(jobJCL, jobOutput);
                String message = String.format("Job %s ended with return code %d%n%s", jobId, rc, conditionCodes);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                Scope.getCurrentScope().getLog(JclRunner.class).warning(message);
                return;
            }
            if (!errorMatcher.matches()) continue;
            String notExecuted = this.parseOutputForNotExecuted(jobJCL, jobOutput);
            String conditionCodes = this.parseOutputForConditionCodes(jobJCL, jobOutput);
            String statementMessages = this.parseOutputForStatementMessages(jobOutput);
            String message = JclRunner.createErrorMessageForJclError(notExecuted, conditionCodes, statementMessages, jobId);
            throw new LiquibaseException(message);
        }
    }

    private static String createErrorMessageForJclError(String notExecuted, String conditionCodes, String statementMessages, String jobId) {
        StringBuilder errorMessage = new StringBuilder();
        if (!notExecuted.isEmpty()) {
            errorMessage.append(String.format("%s%n", notExecuted));
        }
        if (!conditionCodes.isEmpty()) {
            errorMessage.append(conditionCodes);
            errorMessage.append(System.lineSeparator());
        }
        if (!statementMessages.isEmpty()) {
            errorMessage.append(statementMessages);
            errorMessage.append(System.lineSeparator());
        }
        return String.format("Job %s ended in a JCL error%n%s%n", jobId, errorMessage);
    }

    private String parseOutputForConditionCodes(JclJob jclJob, List<JclJobOutput> jobOutput) {
        StringBuilder conditionCodes = new StringBuilder();
        String pattern = ".*?" + jclJob.getJobName().replace("$", "\\$") + " (.*?) - STEP WAS EXECUTED - COND CODE ([0-9]+)";
        Pattern p = Pattern.compile(pattern);
        for (JclJobOutput jclJobOutput : jobOutput) {
            String line = jclJobOutput.getText();
            Matcher m = p.matcher(line.trim());
            if (!m.matches()) continue;
            String matchedRC = m.group(2);
            try {
                int conditionCode = Integer.parseInt(matchedRC);
                if (conditionCode == 0) continue;
                conditionCodes.append(String.format("Step %s had a condition code of %s%n", m.group(1), matchedRC));
            }
            catch (NumberFormatException nfe) {
                Scope.getCurrentScope().getLog(JclRunner.class).warning(String.format("Unable to parse condition code from %s", matchedRC));
            }
        }
        return conditionCodes.toString();
    }

    private String parseOutputForStatementMessages(List<JclJobOutput> jobOutput) {
        StringBuilder statementMessages = new StringBuilder();
        String patternString = ".*?STMT NO. MESSAGE.*";
        String statementString = "^[ ]+?\\d.*";
        Pattern headerPattern = Pattern.compile(patternString);
        Pattern messageLinePattern = Pattern.compile(statementString);
        boolean found = false;
        for (JclJobOutput jclJobOutput : jobOutput) {
            String line = jclJobOutput.getText();
            Matcher m = headerPattern.matcher(line);
            if (m.matches()) {
                statementMessages.append(String.format("%s%n", line));
                found = true;
                continue;
            }
            if (!found) continue;
            Matcher messageLineMatcher = messageLinePattern.matcher(line);
            if (!messageLineMatcher.matches()) break;
            statementMessages.append(String.format("%s%n", line));
        }
        return statementMessages.toString();
    }

    private String parseOutputForNotExecuted(JclJob jclJob, List<JclJobOutput> jobOutput) {
        StringBuilder notExecuted = new StringBuilder();
        String pattern = ".*?" + jclJob.getJobName().replace("$", "\\$") + " (.*?) - STEP WAS NOT EXECUTED.*";
        Pattern p = Pattern.compile(pattern);
        for (JclJobOutput jclJobOutput : jobOutput) {
            String line = jclJobOutput.getText();
            Matcher m = p.matcher(line.trim());
            if (!m.matches()) continue;
            notExecuted.append(String.format("Step %s was not executed%n", m.group(1)));
        }
        return notExecuted.toString();
    }

    @Generated
    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @Generated
    public String getLogFile() {
        return this.logFile;
    }
}

