/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeStatus;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.DbmsTargetedChange;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.core.DB2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateProcedureStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

@DatabaseChange(name="createProcedure", description="Defines the definition for a stored procedure. This command is better to use for creating procedures than the raw sql command because it will not attempt to strip comments or break up lines.\n\nOften times it is best to use the CREATE OR REPLACE syntax along with setting runOnChange='true' on the enclosing changeSet tag. That way if you need to make a change to your procedure you can simply change your existing code rather than creating a new REPLACE PROCEDURE call. The advantage to this approach is that it keeps your change log smaller and allows you to more easily see what has changed in your procedure code through your source control system's diff command.", priority=1)
public class CreateProcedureChange
extends AbstractChange
implements DbmsTargetedChange {
    private String comments;
    private String catalogName;
    private String schemaName;
    private String procedureName;
    private String procedureText;
    private String dbms;
    private String path;
    private Boolean relativeToChangelogFile;
    private String encoding = null;
    private Boolean replaceIfExists;

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(exampleValue="new_customer")
    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @DatabaseChangeProperty(description="File containing the procedure text. Either this attribute or a nested procedure text is required.", exampleValue="com/example/my-logic.sql")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE, exampleValue="CREATE OR REPLACE PROCEDURE testHello\n    IS\n    BEGIN\n      DBMS_OUTPUT.PUT_LINE('Hello From The Database!');\n    END;")
    public String getProcedureBody() {
        return this.procedureText;
    }

    public void setProcedureBody(String procedureText) {
        this.procedureText = procedureText;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.procedureText;
    }

    public void setProcedureText(String procedureText) {
        this.procedureText = procedureText;
    }

    @Override
    @DatabaseChangeProperty(since="3.1", exampleValue="h2, oracle")
    public String getDbms() {
        return this.dbms;
    }

    @Override
    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @DatabaseChangeProperty
    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(Boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validate = new ValidationErrors();
        if (StringUtils.trimToNull(this.getProcedureText()) != null && StringUtils.trimToNull(this.getPath()) != null) {
            validate.addError("Cannot specify both 'path' and a nested procedure text in " + ChangeFactory.getInstance().getChangeMetaData(this).getName());
        }
        if (StringUtils.trimToNull(this.getProcedureText()) == null && StringUtils.trimToNull(this.getPath()) == null) {
            validate.addError("Cannot specify either 'path' or a nested procedure text in " + ChangeFactory.getInstance().getChangeMetaData(this).getName());
        }
        if (this.getReplaceIfExists() != null && DatabaseList.definitionMatches(this.getDbms(), database, true)) {
            if (database instanceof MSSQLDatabase) {
                if (this.getReplaceIfExists().booleanValue() && this.getProcedureName() == null) {
                    validate.addError("procedureName is required if replaceIfExists = true");
                }
            } else {
                validate.checkDisallowedField("replaceIfExists", this.getReplaceIfExists(), database, new Class[0]);
            }
        }
        return validate;
    }

    public InputStream openSqlStream() throws IOException {
        if (this.path == null) {
            return null;
        }
        try {
            return StreamUtil.openStream(this.getPath(), this.isRelativeToChangelogFile(), this.getChangeSet(), this.getResourceAccessor());
        }
        catch (IOException e) {
            throw new IOException("<" + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " path=" + this.path + "> -Unable to read file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckSum generateCheckSum() {
        if (this.path == null) {
            return super.generateCheckSum();
        }
        InputStream stream = null;
        try {
            stream = this.openSqlStream();
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        try {
            String procedureText = this.procedureText;
            if (stream == null && procedureText == null) {
                procedureText = "";
            }
            String encoding = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
            if (procedureText != null) {
                try {
                    stream = new ByteArrayInputStream(procedureText.getBytes(encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)(encoding + " is not supported by the JVM, this should not happen according to the JavaDoc of the Charset class"));
                }
            }
            CheckSum checkSum = CheckSum.compute(new AbstractSQLChange.NormalizingStream(";", false, false, stream), false);
            CheckSum checkSum2 = CheckSum.compute(super.generateCheckSum().toString() + ":" + checkSum.toString());
            return checkSum2;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        String procedureText;
        String endDelimiter = ";";
        if (database instanceof OracleDatabase) {
            endDelimiter = "\n/";
        } else if (database instanceof DB2Database) {
            endDelimiter = "";
        }
        String path = this.getPath();
        if (path == null) {
            procedureText = StringUtils.trimToNull(this.getProcedureText());
        } else {
            try {
                InputStream stream = this.openSqlStream();
                if (stream == null) {
                    throw new IOException("File does not exist: " + path);
                }
                procedureText = StreamUtil.getStreamContents(stream, this.encoding);
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        return this.generateStatements(procedureText, endDelimiter, database);
    }

    protected SqlStatement[] generateStatements(String logicText, String endDelimiter, Database database) {
        CreateProcedureStatement statement = new CreateProcedureStatement(this.getCatalogName(), this.getSchemaName(), this.getProcedureName(), logicText, endDelimiter);
        statement.setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{statement};
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Cannot check createProcedure status");
    }

    @Override
    public String getConfirmationMessage() {
        return "Stored procedure created";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    protected Map<String, Object> createExampleValueMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (parameterName.equals("procedureText") || parameterName.equals("procedureBody")) {
            Map<String, Object> returnMap = super.createExampleValueMetaData(parameterName, changePropertyAnnotation);
            returnMap.put(new HsqlDatabase().getShortName(), "CREATE PROCEDURE new_customer(firstname VARCHAR(50), lastname VARCHAR(50))\n   MODIFIES SQL DATA\n   INSERT INTO CUSTOMERS (first_name, last_name) VALUES (firstname, lastname)");
            return returnMap;
        }
        return super.createExampleValueMetaData(parameterName, changePropertyAnnotation);
    }
}

