/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionStatement;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class DropFunctionGenerator
extends AbstractSqlGenerator<DropFunctionStatement> {
    @Override
    public ValidationErrors validate(DropFunctionStatement dropFunctionStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("functionName", dropFunctionStatement.getFunctionName());
        ((ValidationErrors)object).checkDisallowedField("catalogName", dropFunctionStatement.getCatalogName(), database, MSSQLDatabase.class);
        return object;
    }

    @Override
    public Sql[] generateSql(DropFunctionStatement dropFunctionStatement, Database database, SqlGeneratorChain object) {
        object = database.escapeObjectName(dropFunctionStatement.getCatalogName(), dropFunctionStatement.getSchemaName(), dropFunctionStatement.getFunctionName(), Function.class);
        if (database instanceof PostgresDatabase) {
            object = dropFunctionStatement.getSchemaName() == null ? database.getDefaultSchemaName() : dropFunctionStatement.getSchemaName();
            object = database.escapeObjectName((String)object, Schema.class) + "." + dropFunctionStatement.getFunctionName();
            if (!DropFunctionGenerator.supportsUniqueFunctionDrop(database)) {
                object = (String)object + "()";
            }
        }
        object = new UnparsedSql("DROP FUNCTION ".concat(String.valueOf(object)), new DatabaseObject[]{((Function)new Function().setName(dropFunctionStatement.getFunctionName())).setSchema(new Schema(dropFunctionStatement.getCatalogName(), dropFunctionStatement.getSchemaName()))});
        return new Sql[]{object};
    }

    private static boolean supportsUniqueFunctionDrop(Database database) {
        try {
            return database.getDatabaseMajorVersion() > 9;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

