/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.database.ConnectionServiceFactory;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.InternalDatabase;
import liquibase.database.LiquibaseExtDriver;
import liquibase.database.OfflineConnection;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class DatabaseFactory {
    private static final Logger LOG = Scope.getCurrentScope().getLog(DatabaseFactory.class);
    private static DatabaseFactory instance;
    private Map<String, SortedSet<Database>> implementedDatabases = new HashMap<String, SortedSet<Database>>();
    private Map<String, SortedSet<Database>> internalDatabases = new HashMap<String, SortedSet<Database>>();

    private DatabaseFactory() {
        try {
            for (Database database : Scope.getCurrentScope().getServiceLocator().findInstances(Database.class)) {
                this.register(database);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static synchronized DatabaseFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(DatabaseFactory databaseFactory) {
        instance = databaseFactory;
    }

    public static synchronized void reset() {
        instance = new DatabaseFactory();
    }

    public List<Database> getImplementedDatabases() {
        ArrayList<Database> returnList = new ArrayList<Database>();
        for (SortedSet<Database> set : this.implementedDatabases.values()) {
            returnList.add((Database)set.iterator().next());
        }
        return returnList;
    }

    public List<Database> getInternalDatabases() {
        ArrayList<Database> returnList = new ArrayList<Database>();
        for (SortedSet<Database> set : this.internalDatabases.values()) {
            returnList.add((Database)set.iterator().next());
        }
        return returnList;
    }

    public void register(Database database) {
        Map<String, SortedSet<Database>> map = null;
        map = database instanceof InternalDatabase ? this.internalDatabases : this.implementedDatabases;
        if (!map.containsKey(database.getShortName())) {
            map.put(database.getShortName(), new TreeSet<Database>((SortedSet<Database>)new TreeSet<Database>(new DatabaseComparator())));
        }
        map.get(database.getShortName()).add(database);
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection connection) throws DatabaseException {
        Database returnDatabase;
        TreeSet<Database> foundDatabases = new TreeSet<Database>(new DatabaseComparator());
        for (Database implementedDatabase : this.getImplementedDatabases()) {
            if (connection instanceof OfflineConnection) {
                if (!((OfflineConnection)connection).isCorrectDatabaseImplementation(implementedDatabase)) continue;
                foundDatabases.add(implementedDatabase);
                continue;
            }
            if (!implementedDatabase.isCorrectDatabaseImplementation(connection)) continue;
            foundDatabases.add(implementedDatabase);
        }
        if (foundDatabases.isEmpty()) {
            LOG.warning("Unknown database: " + connection.getDatabaseProductName());
            UnsupportedDatabase unsupportedDB = new UnsupportedDatabase();
            unsupportedDB.setConnection(connection);
            return unsupportedDB;
        }
        try {
            returnDatabase = (Database)((Database)foundDatabases.iterator().next()).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        returnDatabase.setConnection(connection);
        return returnDatabase;
    }

    public Database openDatabase(String url, String username, String password, String propertyProviderClass, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.openDatabase(url, username, password, null, null, null, propertyProviderClass, resourceAccessor);
    }

    public Database openDatabase(String url, String username, String password, String driver, String databaseClass, String driverPropertiesFile, String propertyProviderClass, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.findCorrectDatabaseImplementation(this.openConnection(url, username, password, driver, databaseClass, driverPropertiesFile, propertyProviderClass, resourceAccessor));
    }

    public DatabaseConnection openConnection(String url, String username, String password, String propertyProvider, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.openConnection(url, username, password, null, null, null, propertyProvider, resourceAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection openConnection(String url, String username, String password, String driver, String databaseClass, String driverPropertiesFile, String propertyProviderClass, ResourceAccessor resourceAccessor) throws DatabaseException {
        if (url.startsWith("offline:")) {
            OfflineConnection offlineConnection = new OfflineConnection(url, resourceAccessor);
            offlineConnection.setConnectionUserName(username);
            return offlineConnection;
        }
        DatabaseConnection databaseConnection = null;
        if ((driver = StringUtil.trimToNull(driver)) == null) {
            driver = DatabaseFactory.getInstance().findDefaultDriver(url);
        }
        try {
            Driver driverObject;
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            if (databaseClass != null) {
                databaseFactory.clearRegistry();
                databaseFactory.register((Database)Class.forName(databaseClass, true, Scope.getCurrentScope().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            try {
                if (driver == null) {
                    driver = databaseFactory.findDefaultDriver(url);
                }
                if (driver == null) {
                    throw new RuntimeException("Driver class was not specified and could not be determined from the url (" + url + ")");
                }
                driverObject = (Driver)Class.forName(driver, true, Scope.getCurrentScope().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                throw new RuntimeException("Cannot find database driver: " + e2.getMessage());
            }
            if (driverObject instanceof LiquibaseExtDriver) {
                ((LiquibaseExtDriver)((Object)driverObject)).setResourceAccessor(resourceAccessor);
            }
            Properties driverProperties = propertyProviderClass == null ? new Properties() : (Properties)Class.forName(propertyProviderClass, true, Scope.getCurrentScope().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (username != null) {
                driverProperties.put("user", username);
            }
            if (password != null) {
                driverProperties.put("password", password);
            }
            if (null != driverPropertiesFile) {
                File propertiesFile = new File(driverPropertiesFile);
                if (propertiesFile.exists()) {
                    LOG.fine("Loading properties from the file:'" + driverPropertiesFile + "'");
                    try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
                        driverProperties.load(inputStream);
                    }
                } else {
                    throw new RuntimeException("Can't open JDBC Driver specific properties from the file: '" + driverPropertiesFile + "'");
                }
            }
            LOG.fine("Properties:");
            for (Map.Entry<Object, Object> entry : driverProperties.entrySet()) {
                if (entry.getKey().toString().toLowerCase().contains("password")) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Key:'" + entry.getKey().toString() + "' Value:'**********'");
                    continue;
                }
                LOG.fine("Key:'" + entry.getKey().toString() + "' Value:'" + entry.getValue().toString() + "'");
            }
            if (driver.contains("oracle")) {
                driverProperties.put("remarksReporting", "true");
            } else if (driver.contains("mysql")) {
                driverProperties.put("useInformationSchema", "true");
            }
            LOG.fine("Connecting to the URL:'" + url + "' using driver:'" + driverObject.getClass().getName() + "'");
            databaseConnection = ConnectionServiceFactory.getInstance().create(url, driverObject, driverProperties);
            LOG.fine("Connection has been created");
        }
        catch (Exception e3) {
            throw new DatabaseException(e3);
        }
        return databaseConnection;
    }

    public String findDefaultDriver(String url) {
        for (Database database : this.getImplementedDatabases()) {
            String defaultDriver = database.getDefaultDriver(url);
            if (defaultDriver == null) continue;
            return defaultDriver;
        }
        return null;
    }

    public void clearRegistry() {
        this.implementedDatabases.clear();
    }

    public Database getDatabase(String shortName) {
        if (!this.implementedDatabases.containsKey(shortName)) {
            return null;
        }
        return (Database)this.implementedDatabases.get(shortName).iterator().next();
    }

    private static class DatabaseComparator
    implements Comparator<Database> {
        private DatabaseComparator() {
        }

        @Override
        public int compare(Database o1, Database o2) {
            return -1 * Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
        }
    }
}

