/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import java.util.HashMap;
import java.util.Map;
import liquibase.logging.Logger;
import liquibase.logging.core.AbstractLogService;
import liquibase.logging.core.JavaLogger;
import liquibase.serializer.LiquibaseSerializable;

public class JavaLogService
extends AbstractLogService {
    private Map<Class, JavaLogger> loggers = new HashMap<Class, JavaLogger>();

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Logger getLog(Class clazz) {
        JavaLogger logger = this.loggers.get(clazz);
        if (logger == null) {
            java.util.logging.Logger utilLogger = java.util.logging.Logger.getLogger(this.getLogName(clazz));
            utilLogger.setUseParentHandlers(true);
            logger = new JavaLogger(utilLogger);
            this.loggers.put(clazz, logger);
        }
        return logger;
    }

    protected String getLogName(Class clazz) {
        String superclassLogName;
        String classPackageName = clazz.getPackage().getName();
        if (classPackageName.equals("liquibase")) {
            return "liquibase";
        }
        if (classPackageName.startsWith("liquibase.")) {
            return classPackageName.replaceFirst("(liquibase.\\w+)\\.?.*", "$1");
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            String interfaceLog;
            if (iface.equals(LiquibaseSerializable.class) || (interfaceLog = this.getLogName(iface)).equals("liquibase")) continue;
            return interfaceLog;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class) && !(superclassLogName = this.getLogName(superclass)).equals("liquibase")) {
            return superclassLogName;
        }
        return "liquibase";
    }
}

