/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.liquibase.maven.property.PropertyElement;

public class MavenUtils {
    public static final String LOG_SEPARATOR = "------------------------------------------------------------------------";

    public static ClassLoader getArtifactClassloader(MavenProject project, boolean includeArtifact, boolean includeTestOutputDirectory, Class clazz, Log log, boolean verbose) throws MalformedURLException {
        if (verbose) {
            log.info((CharSequence)"Loading artifacts into URLClassLoader");
        }
        HashSet<URI> uris = new HashSet<URI>();
        Set dependencies = project.getArtifacts();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Artifact dependency : dependencies) {
                MavenUtils.addArtifact(uris, dependency, log, verbose);
            }
        } else {
            log.info((CharSequence)"there are no resolved artifacts for the Maven project.");
        }
        if (includeArtifact) {
            Artifact a = project.getArtifact();
            if (a.getFile() != null) {
                MavenUtils.addArtifact(uris, a, log, verbose);
            } else {
                MavenUtils.addFile(uris, new File(project.getBuild().getOutputDirectory()), log, verbose);
            }
        }
        if (includeTestOutputDirectory) {
            MavenUtils.addFile(uris, new File(project.getBuild().getTestOutputDirectory()), log, verbose);
        }
        if (verbose) {
            log.info((CharSequence)LOG_SEPARATOR);
        }
        ArrayList uriList = new ArrayList(uris);
        URL[] urlArray = new URL[uris.size()];
        for (int i = 0; i < uris.size(); ++i) {
            urlArray[i] = ((URI)uriList.get(i)).toURL();
        }
        return new URLClassLoader(urlArray, clazz.getClassLoader());
    }

    private static void addArtifact(Set<URI> urls, Artifact artifact, Log log, boolean verbose) throws MalformedURLException {
        File f = artifact.getFile();
        if (f == null) {
            log.warn((CharSequence)("Artifact with no actual file, '" + artifact.getGroupId() + ":" + artifact.getArtifactId() + "'"));
        } else {
            MavenUtils.addFile(urls, f, log, verbose);
        }
    }

    private static void addFile(Set<URI> urls, File f, Log log, boolean verbose) throws MalformedURLException {
        if (f != null) {
            URI fileUri = f.toURI();
            if (verbose) {
                log.info((CharSequence)("  artifact: " + fileUri));
            }
            urls.add(fileUri);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String keyPropertyName) throws NoSuchFieldException {
        Field f = MavenUtils.getField(clazz, keyPropertyName);
        if (f == null) {
            Class<?> parent = clazz.getSuperclass();
            if (parent != null) {
                return MavenUtils.getDeclaredField(parent, keyPropertyName);
            }
            throw new NoSuchFieldException("The field '" + keyPropertyName + "' could not be found in the class of any of its parent classes.");
        }
        return f;
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            PropertyElement annotation = field.getAnnotation(PropertyElement.class);
            if (annotation != null && annotation.key().equalsIgnoreCase(fieldName)) {
                return field;
            }
            if (!fields[i].getName().equalsIgnoreCase(fieldName)) continue;
            return fields[i];
        }
        return null;
    }
}

