/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.time.Clock;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.mapstruct.extensions.spring.converter.AdapterRelatedGenerator;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;
import org.mapstruct.extensions.spring.converter.FromToMapping;
import org.mapstruct.extensions.spring.converter.TypeNameUtils;

public class ConversionServiceAdapterGenerator
extends AdapterRelatedGenerator {
    private static final ClassName CONVERSION_SERVICE_CLASS_NAME = ClassName.get((String)"org.springframework.core.convert", (String)"ConversionService", (String[])new String[0]);
    private static final String CONVERSION_SERVICE_FIELD_NAME = "conversionService";
    private static final ClassName QUALIFIER_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Qualifier", (String[])new String[0]);
    private static final ClassName LAZY_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.context.annotation", (String)"Lazy", (String[])new String[0]);
    private static final ClassName TYPE_DESCRIPTOR_CLASS_NAME = ClassName.get((String)"org.springframework.core.convert", (String)"TypeDescriptor", (String[])new String[0]);
    private static final ClassName COMPONENT_ANNOTATION_CLASS_NAME = ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0]);

    public ConversionServiceAdapterGenerator(Clock clock) {
        super(clock);
    }

    @Override
    protected TypeSpec createMainTypeSpec(ConversionServiceAdapterDescriptor descriptor) {
        FieldSpec conversionServiceFieldSpec = ConversionServiceAdapterGenerator.buildConversionServiceFieldSpec();
        TypeSpec.Builder adapterClassTypeSpec = TypeSpec.classBuilder((ClassName)descriptor.getAdapterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional.ofNullable(this.buildGeneratedAnnotationSpec()).ifPresent(arg_0 -> ((TypeSpec.Builder)adapterClassTypeSpec).addAnnotation(arg_0));
        return adapterClassTypeSpec.addAnnotation(COMPONENT_ANNOTATION_CLASS_NAME).addField(conversionServiceFieldSpec).addMethod(ConversionServiceAdapterGenerator.buildConstructorSpec(descriptor, conversionServiceFieldSpec)).addMethods(this.buildMappingMethods(descriptor, conversionServiceFieldSpec)).build();
    }

    private static MethodSpec buildConstructorSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec constructorParameterSpec = ConversionServiceAdapterGenerator.buildConstructorParameterSpec(descriptor, conversionServiceFieldSpec);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(constructorParameterSpec).addStatement("this.$N = $N", new Object[]{conversionServiceFieldSpec, constructorParameterSpec}).build();
    }

    private static ParameterSpec buildConstructorParameterSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)conversionServiceFieldSpec.type, (String)conversionServiceFieldSpec.name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (descriptor.hasNonDefaultConversionServiceBeanName()) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildQualifierAnnotation(descriptor));
        }
        if (Boolean.TRUE.equals(descriptor.isLazyAnnotatedConversionServiceBean())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildLazyAnnotation());
        }
        return parameterBuilder.build();
    }

    private static AnnotationSpec buildQualifierAnnotation(ConversionServiceAdapterDescriptor descriptor) {
        return AnnotationSpec.builder((ClassName)QUALIFIER_ANNOTATION_CLASS_NAME).addMember("value", "$S", new Object[]{descriptor.getConversionServiceBeanName()}).build();
    }

    private static AnnotationSpec buildLazyAnnotation() {
        return AnnotationSpec.builder((ClassName)LAZY_ANNOTATION_CLASS_NAME).build();
    }

    private Iterable<MethodSpec> buildMappingMethods(ConversionServiceAdapterDescriptor descriptor, FieldSpec injectedConversionServiceFieldSpec) {
        return descriptor.getFromToMappings().stream().map(fromToMapping -> this.toMappingMethodSpec(injectedConversionServiceFieldSpec, (FromToMapping)fromToMapping)).collect(Collectors.toList());
    }

    private MethodSpec toMappingMethodSpec(FieldSpec injectedConversionServiceFieldSpec, FromToMapping fromToMapping) {
        ParameterSpec sourceParameterSpec = ConversionServiceAdapterGenerator.buildSourceParameterSpec(fromToMapping.getSource());
        return MethodSpec.methodBuilder((String)fromToMapping.getAdapterMethodName().orElse(String.format("map%sTo%s", this.collectionOfNameIfApplicable(fromToMapping.getSource()), this.collectionOfNameIfApplicable(fromToMapping.getTarget())))).addParameter(sourceParameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fromToMapping.getTarget()).addStatement(String.format("return ($T) $N.convert($N, %s, %s)", this.typeDescriptorFormat(fromToMapping.getSource()), this.typeDescriptorFormat(fromToMapping.getTarget())), this.allTypeDescriptorArguments(injectedConversionServiceFieldSpec, sourceParameterSpec, fromToMapping)).build();
    }

    private Object[] allTypeDescriptorArguments(FieldSpec injectedConversionServiceFieldSpec, ParameterSpec sourceParameterSpec, FromToMapping fromToMapping) {
        return Stream.concat(Stream.concat(Stream.of(fromToMapping.getTarget(), injectedConversionServiceFieldSpec, sourceParameterSpec), this.typeDescriptorArguments(fromToMapping.getSource())), this.typeDescriptorArguments(fromToMapping.getTarget())).toArray();
    }

    private String typeDescriptorFormat(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName && this.isCollectionWithGenericParameter((ParameterizedTypeName)typeName)) {
            return String.format("$T.collection($T.class, %s)", this.typeDescriptorFormat((TypeName)((ParameterizedTypeName)typeName).typeArguments.iterator().next()));
        }
        return "$T.valueOf($T.class)";
    }

    private Stream<Object> typeDescriptorArguments(TypeName typeName) {
        return typeName instanceof ParameterizedTypeName && this.isCollectionWithGenericParameter((ParameterizedTypeName)typeName) ? Stream.concat(Stream.of(TYPE_DESCRIPTOR_CLASS_NAME, ((ParameterizedTypeName)typeName).rawType), this.typeDescriptorArguments((TypeName)((ParameterizedTypeName)typeName).typeArguments.iterator().next())) : Stream.of(TYPE_DESCRIPTOR_CLASS_NAME, TypeNameUtils.rawType(typeName));
    }

    private static ParameterSpec buildSourceParameterSpec(TypeName sourceClassName) {
        return ParameterSpec.builder((TypeName)sourceClassName, (String)"source", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
    }

    private static FieldSpec buildConversionServiceFieldSpec() {
        return FieldSpec.builder((TypeName)CONVERSION_SERVICE_CLASS_NAME, (String)CONVERSION_SERVICE_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }
}

