/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util.workarounds;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class EclipseClassLoaderBridge {
    private static final String ECLIPSE_AS_MEMBER_OF_WORKAROUND = "org.mapstruct.ap.internal.util.workarounds.EclipseAsMemberOfWorkaround";
    private static ClassLoader classLoader;
    private static Method asMemberOf;

    private EclipseClassLoaderBridge() {
    }

    static TypeMirror invokeAsMemberOfWorkaround(ProcessingEnvironment env, DeclaredType containing, Element element) throws Exception {
        return (TypeMirror)EclipseClassLoaderBridge.getAsMemberOf(element.getClass().getClassLoader()).invoke(null, env, containing, element);
    }

    private static ClassLoader getOrCreateClassLoader(ClassLoader parent) {
        if (classLoader == null) {
            classLoader = new URLClassLoader(((URLClassLoader)EclipseClassLoaderBridge.class.getClassLoader()).getURLs(), parent);
        }
        return classLoader;
    }

    private static Method getAsMemberOf(ClassLoader platformClassLoader) throws Exception {
        if (asMemberOf == null) {
            Class<?> workaroundClass = EclipseClassLoaderBridge.getOrCreateClassLoader(platformClassLoader).loadClass(ECLIPSE_AS_MEMBER_OF_WORKAROUND);
            Method found = workaroundClass.getDeclaredMethod("asMemberOf", ProcessingEnvironment.class, DeclaredType.class, Element.class);
            found.setAccessible(true);
            asMemberOf = found;
        }
        return asMemberOf;
    }
}

