/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.gem.ReportingPolicyGem;
import org.mapstruct.ap.internal.model.AbstractMappingMethodBuilder;
import org.mapstruct.ap.internal.model.BuilderFinisherMethodResolver;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedTargetPropertyMappingHolder;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.SubclassMapping;
import org.mapstruct.ap.internal.model.beanmapping.AbstractReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReference;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.beanmapping.TargetReference;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SubclassMappingOptions;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.ParameterElementAccessor;
import org.mapstruct.ap.internal.util.accessor.PresenceCheckAccessor;
import org.mapstruct.ap.internal.util.accessor.ReadAccessor;

public class BeanMappingMethod
extends NormalTypeMappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final Map<String, List<PropertyMapping>> constructorMappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final List<PropertyMapping> constructorConstantMappings;
    private final List<SubclassMapping> subclassMappings;
    private final Type returnTypeToConstruct;
    private final BuilderType returnTypeBuilder;
    private final MethodReference finalizerMethod;
    private final MappingReferences mappingReferences;

    private BeanMappingMethod(Method method, Collection<String> existingVariableNames, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type returnTypeToConstruct, BuilderType returnTypeBuilder, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, MethodReference finalizerMethod, MappingReferences mappingReferences, List<SubclassMapping> subclassMappings) {
        super(method, existingVariableNames, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.returnTypeBuilder = returnTypeBuilder;
        this.finalizerMethod = finalizerMethod;
        this.mappingReferences = mappingReferences;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings.size());
        this.constructorMappingsByParameter = new LinkedHashMap<String, List<PropertyMapping>>();
        this.constructorConstantMappings = new ArrayList<PropertyMapping>();
        Set sourceParameterNames = this.getSourceParameters().stream().map(Parameter::getName).collect(Collectors.toSet());
        for (PropertyMapping mapping : propertyMappings) {
            if (mapping.isConstructorMapping()) {
                if (sourceParameterNames.contains(mapping.getSourceBeanName())) {
                    this.constructorMappingsByParameter.computeIfAbsent(mapping.getSourceBeanName(), key -> new ArrayList()).add(mapping);
                    continue;
                }
                this.constructorConstantMappings.add(mapping);
                continue;
            }
            if (sourceParameterNames.contains(mapping.getSourceBeanName())) {
                this.mappingsByParameter.computeIfAbsent(mapping.getSourceBeanName(), key -> new ArrayList()).add(mapping);
                continue;
            }
            this.constantMappings.add(mapping);
        }
        this.returnTypeToConstruct = returnTypeToConstruct;
        this.subclassMappings = subclassMappings;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public List<PropertyMapping> getConstructorConstantMappings() {
        return this.constructorConstantMappings;
    }

    public List<SubclassMapping> getSubclassMappings() {
        return this.subclassMappings;
    }

    public List<PropertyMapping> propertyMappingsByParameter(Parameter parameter) {
        return this.mappingsByParameter.getOrDefault(parameter.getName(), java.util.Collections.emptyList());
    }

    public List<PropertyMapping> constructorPropertyMappingsByParameter(Parameter parameter) {
        return this.constructorMappingsByParameter.getOrDefault(parameter.getName(), java.util.Collections.emptyList());
    }

    public Type getReturnTypeToConstruct() {
        return this.returnTypeToConstruct;
    }

    public boolean hasSubclassMappings() {
        return !this.subclassMappings.isEmpty();
    }

    public boolean isAbstractReturnType() {
        return this.getFactoryMethod() == null && this.returnTypeToConstruct != null && this.returnTypeToConstruct.isAbstract();
    }

    public boolean hasConstructorMappings() {
        return !this.constructorMappingsByParameter.isEmpty() || !this.constructorConstantMappings.isEmpty();
    }

    public MethodReference getFinalizerMethod() {
        return this.finalizerMethod;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
            if (!propertyMapping.isConstructorMapping()) continue;
            types.addAll(propertyMapping.getTargetType().getImportTypes());
        }
        for (SubclassMapping subclassMapping : this.subclassMappings) {
            types.addAll(subclassMapping.getImportTypes());
        }
        if (this.returnTypeToConstruct != null) {
            types.addAll(this.returnTypeToConstruct.getImportTypes());
        }
        if (this.returnTypeBuilder != null) {
            types.add(this.returnTypeBuilder.getOwningType());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        return this.getSourceParameters().stream().filter(parameter -> !parameter.getType().isPrimitive()).collect(Collectors.toList());
    }

    public List<Parameter> getSourceParametersNeedingNullCheck() {
        return this.getSourceParameters().stream().filter(this::needsNullCheck).collect(Collectors.toList());
    }

    public List<Parameter> getSourceParametersNotNeedingNullCheck() {
        return this.getSourceParameters().stream().filter(parameter -> !this.needsNullCheck((Parameter)parameter)).collect(Collectors.toList());
    }

    private boolean needsNullCheck(Parameter parameter) {
        if (parameter.getType().isPrimitive()) {
            return false;
        }
        List<PropertyMapping> mappings = this.propertyMappingsByParameter(parameter);
        if (mappings.size() == 1 && this.doesNotNeedNullCheckForSourceParameter(mappings.get(0))) {
            return false;
        }
        mappings = this.constructorPropertyMappingsByParameter(parameter);
        return mappings.size() != 1 || !this.doesNotNeedNullCheckForSourceParameter(mappings.get(0));
    }

    private boolean doesNotNeedNullCheckForSourceParameter(PropertyMapping mapping) {
        if (mapping.getAssignment().isCallingUpdateMethod()) {
            return false;
        }
        return mapping.getAssignment().isSourceReferenceParameter();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanMappingMethod that = (BeanMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!Objects.equals(this.propertyMappings, that.propertyMappings)) {
            return false;
        }
        return Objects.equals(this.mappingReferences, that.mappingReferences);
    }

    private static class ConstructorAccessor {
        private final List<ParameterBinding> parameterBindings;
        private final Map<String, Accessor> constructorAccessors;

        private ConstructorAccessor(List<ParameterBinding> parameterBindings, Map<String, Accessor> constructorAccessors) {
            this.parameterBindings = parameterBindings;
            this.constructorAccessors = constructorAccessors;
        }
    }

    public static class Builder
    extends AbstractMappingMethodBuilder<Builder, BeanMappingMethod> {
        private Type userDefinedReturnType;
        private BuilderType returnTypeBuilder;
        private Map<String, Accessor> unprocessedConstructorProperties;
        private Map<String, Accessor> unprocessedTargetProperties;
        private Map<String, Accessor> unprocessedSourceProperties;
        private Set<String> missingIgnoredSourceProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private final Set<String> existingVariableNames = new HashSet<String>();
        private final Map<String, Set<MappingReference>> unprocessedDefinedTargets = new LinkedHashMap<String, Set<MappingReference>>();
        private MappingReferences mappingReferences;
        private MethodReference factoryMethod;
        private boolean hasFactoryMethod;

        public Builder() {
            super(Builder.class);
        }

        @Override
        protected boolean shouldUsePropertyNamesInHistory() {
            return true;
        }

        public Builder userDefinedReturnType(Type userDefinedReturnType) {
            this.userDefinedReturnType = userDefinedReturnType;
            return this;
        }

        public Builder returnTypeBuilder(BuilderType returnTypeBuilder) {
            this.returnTypeBuilder = returnTypeBuilder;
            return this;
        }

        public Builder sourceMethod(SourceMethod sourceMethod) {
            this.method(sourceMethod);
            return this;
        }

        public Builder forgedMethod(ForgedMethod forgedMethod) {
            this.method(forgedMethod);
            this.mappingReferences = forgedMethod.getMappingReferences();
            Parameter sourceParameter = Collections.first(Parameter.getSourceParameters(forgedMethod.getParameters()));
            for (MappingReference mappingReference : this.mappingReferences.getMappingReferences()) {
                SourceReference sourceReference = mappingReference.getSourceReference();
                if (sourceReference == null) continue;
                mappingReference.setSourceReference(new SourceReference.BuilderFromSourceReference().sourceParameter(sourceParameter).sourceReference(sourceReference).build());
            }
            return this;
        }

        @Override
        public BeanMappingMethod build() {
            BeanMappingOptions beanMapping = this.method.getOptions().getBeanMapping();
            SelectionParameters selectionParameters = beanMapping != null ? beanMapping.getSelectionParameters() : null;
            Type returnTypeToConstruct = null;
            boolean cannotConstructReturnType = false;
            if (!this.method.getReturnType().isVoid()) {
                Type returnTypeImpl = null;
                if (this.isBuilderRequired()) {
                    returnTypeImpl = this.returnTypeBuilder.getBuilder();
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.allowsAbstractReturnTypeAndIsEitherAbstractOrCanBeConstructed(returnTypeImpl) || this.doesNotAllowAbstractReturnTypeAndCanBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                } else if (this.userDefinedReturnType != null) {
                    returnTypeImpl = this.userDefinedReturnType;
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.canResultTypeFromBeanMappingBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                } else if (!this.method.isUpdateMethod()) {
                    returnTypeImpl = this.method.getReturnType();
                    this.initializeFactoryMethod(returnTypeImpl, selectionParameters);
                    if (this.factoryMethod != null || this.allowsAbstractReturnTypeAndIsEitherAbstractOrCanBeConstructed(returnTypeImpl) || this.doesNotAllowAbstractReturnTypeAndCanBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    } else {
                        cannotConstructReturnType = true;
                    }
                }
            }
            if (cannotConstructReturnType) {
                return null;
            }
            Type resultTypeToMap = returnTypeToConstruct == null ? this.method.getResultType() : returnTypeToConstruct;
            this.existingVariableNames.addAll(this.method.getParameterNames());
            CollectionMappingStrategyGem cms = this.method.getOptions().getMapper().getCollectionMappingStrategy();
            Map<String, Accessor> accessors = resultTypeToMap.getPropertyWriteAccessors(cms);
            this.targetProperties = new LinkedHashSet<String>(accessors.keySet());
            this.unprocessedTargetProperties = new LinkedHashMap<String, Accessor>(accessors);
            if (!this.method.isUpdateMethod() && !this.hasFactoryMethod) {
                ConstructorAccessor constructorAccessor = this.getConstructorAccessor(resultTypeToMap);
                if (constructorAccessor != null) {
                    this.unprocessedConstructorProperties = constructorAccessor.constructorAccessors;
                    this.factoryMethod = MethodReference.forConstructorInvocation(resultTypeToMap, constructorAccessor.parameterBindings);
                } else {
                    this.unprocessedConstructorProperties = new LinkedHashMap<String, Accessor>();
                }
                this.targetProperties.addAll(this.unprocessedConstructorProperties.keySet());
                this.unprocessedTargetProperties.putAll(this.unprocessedConstructorProperties);
            } else {
                this.unprocessedConstructorProperties = new LinkedHashMap<String, Accessor>();
            }
            this.unprocessedSourceProperties = new LinkedHashMap<String, Accessor>();
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
                if (sourceParameter.getType().isPrimitive() || sourceParameter.getType().isArrayType() || sourceParameter.getType().isMapType()) continue;
                Map<String, ReadAccessor> readAccessors = sourceParameter.getType().getPropertyReadAccessors();
                for (Map.Entry<String, ReadAccessor> entry : readAccessors.entrySet()) {
                    this.unprocessedSourceProperties.put(entry.getKey(), entry.getValue());
                }
            }
            this.missingIgnoredSourceProperties = new HashSet<String>();
            if (beanMapping != null) {
                for (String ignoreUnmapped : beanMapping.getIgnoreUnmappedSourceProperties()) {
                    if (this.unprocessedSourceProperties.remove(ignoreUnmapped) != null) continue;
                    this.missingIgnoredSourceProperties.add(ignoreUnmapped);
                }
            }
            this.initializeMappingReferencesIfNeeded(resultTypeToMap);
            boolean mappingErrorOccurred = this.handleDefinedMappings(resultTypeToMap);
            if (mappingErrorOccurred) {
                return null;
            }
            if (!this.mappingReferences.isRestrictToDefinedMappings()) {
                this.applyTargetThisMapping();
                this.applyPropertyNameBasedMapping();
                this.applyParameterNameBasedMapping();
            }
            this.handleUnprocessedDefinedTargets();
            this.handleUnmappedConstructorProperties();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            this.reportErrorForUnmappedSourcePropertiesIfRequired();
            this.reportErrorForMissingIgnoredSourceProperties();
            this.reportErrorForUnusedSourceParameters();
            boolean mapNullToDefault = this.method.getOptions().getBeanMapping().getNullValueMappingStrategy().isReturnDefault();
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            if (this.method instanceof ForgedMethod) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (this.factoryMethod != null) {
                    forgedMethod.addThrownTypes(this.factoryMethod.getThrownTypes());
                }
                for (PropertyMapping propertyMapping : this.propertyMappings) {
                    if (propertyMapping.getAssignment() == null) continue;
                    forgedMethod.addThrownTypes(propertyMapping.getAssignment().getThrownTypes());
                }
            }
            ArrayList<SubclassMapping> subclasses = new ArrayList<SubclassMapping>();
            for (SubclassMappingOptions subclassMappingOptions : this.method.getOptions().getSubclassMappings()) {
                subclasses.add(this.createSubclassMapping(subclassMappingOptions));
            }
            MethodReference finalizeMethod = null;
            if (this.shouldCallFinalizerMethod(returnTypeToConstruct)) {
                finalizeMethod = this.getFinalizerMethod();
            }
            return new BeanMappingMethod(this.method, this.existingVariableNames, this.propertyMappings, this.factoryMethod, mapNullToDefault, returnTypeToConstruct, this.returnTypeBuilder, beforeMappingMethods, afterMappingMethods, finalizeMethod, this.mappingReferences, subclasses);
        }

        private boolean doesNotAllowAbstractReturnTypeAndCanBeConstructed(Type returnTypeImpl) {
            return !this.isAbstractReturnTypeAllowed() && this.canReturnTypeBeConstructed(returnTypeImpl);
        }

        private boolean allowsAbstractReturnTypeAndIsEitherAbstractOrCanBeConstructed(Type returnTypeImpl) {
            return this.isAbstractReturnTypeAllowed() && this.isReturnTypeAbstractOrCanBeConstructed(returnTypeImpl);
        }

        private SubclassMapping createSubclassMapping(SubclassMappingOptions subclassMappingOptions) {
            TypeFactory typeFactory = this.ctx.getTypeFactory();
            Type sourceType = typeFactory.getType(subclassMappingOptions.getSource());
            Type targetType = typeFactory.getType(subclassMappingOptions.getTarget());
            SourceRHS rightHandSide = new SourceRHS("subclassMapping", sourceType, java.util.Collections.emptySet(), "SubclassMapping for " + sourceType.getFullyQualifiedName());
            SelectionCriteria criteria = SelectionCriteria.forMappingMethods(new SelectionParameters(java.util.Collections.emptyList(), java.util.Collections.emptyList(), subclassMappingOptions.getTarget(), this.ctx.getTypeUtils()).withSourceRHS(rightHandSide), null, null, false);
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, null, targetType, FormattingParameters.EMPTY, criteria, rightHandSide, null, () -> this.forgeSubclassMapping(rightHandSide, sourceType, targetType, this.mappingReferences));
            String sourceArgument = null;
            for (Parameter parameter : this.method.getSourceParameters()) {
                if (!this.ctx.getTypeUtils().isAssignable(sourceType.getTypeMirror(), parameter.getType().getTypeMirror())) continue;
                sourceArgument = parameter.getName();
                assignment.setSourceLocalVarName("(" + sourceType.createReferenceName() + ") " + sourceArgument);
            }
            return new SubclassMapping(sourceType, sourceArgument, targetType, assignment);
        }

        private boolean isAbstractReturnTypeAllowed() {
            return this.method.getOptions().getBeanMapping().getSubclassExhaustiveStrategy().isAbstractReturnTypeAllowed() && !this.method.getOptions().getSubclassMappings().isEmpty();
        }

        private void initializeMappingReferencesIfNeeded(Type resultTypeToMap) {
            if (this.mappingReferences == null && this.method instanceof SourceMethod) {
                HashSet<String> readAndWriteTargetProperties = new HashSet<String>(this.unprocessedTargetProperties.keySet());
                readAndWriteTargetProperties.addAll(resultTypeToMap.getPropertyReadAccessors().keySet());
                this.mappingReferences = MappingReferences.forSourceMethod((SourceMethod)this.method, resultTypeToMap, readAndWriteTargetProperties, this.ctx.getMessager(), this.ctx.getTypeFactory());
            }
        }

        private boolean isBuilderRequired() {
            return this.returnTypeBuilder != null && (!this.method.isUpdateMethod() || !this.method.isMappingTargetAssignableToReturnType());
        }

        private boolean shouldCallFinalizerMethod(Type returnTypeToConstruct) {
            if (returnTypeToConstruct == null) {
                return false;
            }
            if (returnTypeToConstruct.isAssignableTo(this.method.getReturnType())) {
                return false;
            }
            return this.returnTypeBuilder != null;
        }

        private MethodReference getFinalizerMethod() {
            return BuilderFinisherMethodResolver.getBuilderFinisherMethod(this.method, this.returnTypeBuilder, this.ctx);
        }

        private void handleUnprocessedDefinedTargets() {
            Iterator<Map.Entry<String, Set<MappingReference>>> iterator = this.unprocessedDefinedTargets.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<String, Set<MappingReference>> entry = iterator.next();
                String propertyName = entry.getKey();
                if (!this.unprocessedTargetProperties.containsKey(propertyName)) continue;
                List<Parameter> sourceParameters = this.method.getSourceParameters();
                boolean forceUpdateMethod = sourceParameters.size() > 1;
                for (Parameter sourceParameter : sourceParameters) {
                    SourceReference reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(propertyName).build();
                    ReadAccessor targetPropertyReadAccessor = this.method.getResultType().getReadAccessor(propertyName);
                    MappingReferences mappingRefs = this.extractMappingReferences(propertyName, true);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(propertyName, targetPropertyReadAccessor, this.unprocessedTargetProperties.get(propertyName))).sourceReference(reference).existingVariableNames((Set)this.existingVariableNames)).dependsOn((Set)mappingRefs.collectNestedDependsOn())).forgeMethodWithMappingReferences(mappingRefs).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
                    if (propertyMapping == null) continue;
                    this.unprocessedTargetProperties.remove(propertyName);
                    this.unprocessedConstructorProperties.remove(propertyName);
                    this.unprocessedSourceProperties.remove(propertyName);
                    iterator.remove();
                    this.propertyMappings.add(propertyMapping);
                    continue block0;
                }
            }
        }

        private void handleUnmappedConstructorProperties() {
            for (Map.Entry<String, Accessor> entry : this.unprocessedConstructorProperties.entrySet()) {
                Accessor accessor = entry.getValue();
                Type accessedType = this.ctx.getTypeFactory().getType(accessor.getAccessedType());
                String targetPropertyName = entry.getKey();
                this.propertyMappings.add(((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(accessedType.getNull()).existingVariableNames((Set)this.existingVariableNames)).target(targetPropertyName, null, accessor)).dependsOn(java.util.Collections.emptySet())).mirror(null)).build());
            }
            this.unprocessedConstructorProperties.clear();
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping2 : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping2.getName(), propertyMapping2.getDependsOn());
            }
            GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                this.propertyMappings.sort(Comparator.comparingInt(propertyMapping -> graphAnalyzer.getTraversalSequence(propertyMapping.getName())));
            }
        }

        private boolean canResultTypeFromBeanMappingBeConstructed(Type resultType) {
            boolean error = true;
            if (resultType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.BEANMAPPING_ABSTRACT, resultType.describe(), this.method.getResultType().describe());
                error = false;
            } else if (!resultType.isAssignableTo(this.method.getResultType())) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.BEANMAPPING_NOT_ASSIGNABLE, resultType.describe(), this.method.getResultType().describe());
                error = false;
            } else if (!resultType.hasAccessibleConstructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.method.getOptions().getBeanMapping().getMirror(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, resultType.describe());
                error = false;
            }
            return error;
        }

        private boolean canReturnTypeBeConstructed(Type returnType) {
            boolean error = true;
            if (returnType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_ABSTRACT_RETURN_TYPE, returnType.describe());
                error = false;
            } else if (!returnType.hasAccessibleConstructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, returnType.describe());
                error = false;
            }
            return error;
        }

        private boolean isReturnTypeAbstractOrCanBeConstructed(Type returnType) {
            boolean error = true;
            if (!returnType.isAbstract() && !returnType.hasAccessibleConstructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, returnType.describe());
                error = false;
            }
            return error;
        }

        private void initializeFactoryMethod(Type returnTypeImpl, SelectionParameters selectionParameters) {
            List<SelectedMethod<SourceMethod>> matchingFactoryMethods = ObjectFactoryMethodResolver.getMatchingFactoryMethods(this.method, returnTypeImpl, selectionParameters, this.ctx);
            if (matchingFactoryMethods.isEmpty()) {
                if (this.factoryMethod == null && this.returnTypeBuilder != null) {
                    this.factoryMethod = ObjectFactoryMethodResolver.getBuilderFactoryMethod(this.method, this.returnTypeBuilder);
                    this.hasFactoryMethod = this.factoryMethod != null;
                }
            } else if (matchingFactoryMethods.size() == 1) {
                this.factoryMethod = ObjectFactoryMethodResolver.getFactoryMethodReference(this.method, Collections.first(matchingFactoryMethods), this.ctx);
                this.hasFactoryMethod = true;
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_AMBIGUOUS_FACTORY_METHOD, returnTypeImpl.describe(), matchingFactoryMethods.stream().map(SelectedMethod::getMethod).map(Method::describe).collect(Collectors.joining(", ")));
                this.hasFactoryMethod = true;
            }
        }

        private ConstructorAccessor getConstructorAccessor(Type type) {
            if (type.isAbstract()) {
                return null;
            }
            if (type.isRecord()) {
                List<Element> recordComponents = type.getRecordComponents();
                ArrayList<ParameterBinding> parameterBindings = new ArrayList<ParameterBinding>(recordComponents.size());
                LinkedHashMap<String, Accessor> constructorAccessors = new LinkedHashMap<String, Accessor>();
                for (Element recordComponent : recordComponents) {
                    TypeMirror recordComponentMirror = this.ctx.getTypeUtils().asMemberOf((DeclaredType)type.getTypeMirror(), recordComponent);
                    String parameterName = recordComponent.getSimpleName().toString();
                    Accessor accessor = this.createConstructorAccessor(recordComponent, recordComponentMirror, parameterName);
                    constructorAccessors.put(parameterName, accessor);
                    parameterBindings.add(ParameterBinding.fromTypeAndName(this.ctx.getTypeFactory().getType(recordComponentMirror), accessor.getSimpleName()));
                }
                return new ConstructorAccessor(parameterBindings, constructorAccessors);
            }
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getTypeElement().getEnclosedElements());
            ExecutableElement defaultAnnotatedConstructor = null;
            ExecutableElement parameterLessConstructor = null;
            ArrayList<ExecutableElement> accessibleConstructors = new ArrayList<ExecutableElement>(constructors.size());
            ArrayList<ExecutableElement> publicConstructors = new ArrayList<ExecutableElement>();
            for (ExecutableElement constructor : constructors) {
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                if (this.hasDefaultAnnotationFromAnyPackage(constructor)) {
                    defaultAnnotatedConstructor = constructor;
                    break;
                }
                if (constructor.getParameters().isEmpty()) {
                    parameterLessConstructor = constructor;
                } else {
                    accessibleConstructors.add(constructor);
                }
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                publicConstructors.add(constructor);
            }
            if (defaultAnnotatedConstructor != null) {
                return this.getConstructorAccessor(type, defaultAnnotatedConstructor);
            }
            if (publicConstructors.size() == 1) {
                ExecutableElement publicConstructor = (ExecutableElement)publicConstructors.get(0);
                if (publicConstructor.getParameters().isEmpty()) {
                    return null;
                }
                return this.getConstructorAccessor(type, publicConstructor);
            }
            if (parameterLessConstructor != null) {
                return null;
            }
            if (accessibleConstructors.isEmpty()) {
                return null;
            }
            if (accessibleConstructors.size() > 1) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_AMBIGUOUS_CONSTRUCTORS, type, constructors.stream().map(ExecutableElement::getParameters).map(ps -> ps.stream().map(Element::asType).map(String::valueOf).collect(Collectors.joining(", ", type.getName() + "(", ")"))).collect(Collectors.joining(", ")));
                return null;
            }
            return this.getConstructorAccessor(type, (ExecutableElement)accessibleConstructors.get(0));
        }

        private ConstructorAccessor getConstructorAccessor(Type type, ExecutableElement constructor) {
            LinkedHashMap<String, Accessor> constructorAccessors;
            List<Parameter> constructorParameters = this.ctx.getTypeFactory().getParameters((DeclaredType)type.getTypeMirror(), constructor);
            List<String> constructorProperties = null;
            block0: for (AnnotationMirror annotationMirror : constructor.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("ConstructorProperties")) continue;
                for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
                    if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")) continue;
                    constructorProperties = this.getArrayValues((AnnotationValue)entry.getValue());
                    break block0;
                }
            }
            if (constructorProperties == null) {
                constructorAccessors = new LinkedHashMap<String, Accessor>();
                ArrayList<ParameterBinding> arrayList = new ArrayList<ParameterBinding>(constructorParameters.size());
                for (Parameter parameter : constructorParameters) {
                    String parameterName = parameter.getName();
                    Element parameterElement = parameter.getElement();
                    Accessor constructorAccessor = this.createConstructorAccessor(parameterElement, parameter.getType().getTypeMirror(), parameterName);
                    constructorAccessors.put(parameterName, constructorAccessor);
                    arrayList.add(ParameterBinding.fromTypeAndName(parameter.getType(), constructorAccessor.getSimpleName()));
                }
                return new ConstructorAccessor(arrayList, constructorAccessors);
            }
            if (constructorProperties.size() != constructorParameters.size()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_CONSTRUCTOR_PROPERTIES_NOT_MATCHING_PARAMETERS, type);
                return null;
            }
            constructorAccessors = new LinkedHashMap();
            ArrayList<ParameterBinding> arrayList = new ArrayList<ParameterBinding>(constructorProperties.size());
            for (int i = 0; i < constructorProperties.size(); ++i) {
                String string = (String)constructorProperties.get(i);
                Parameter constructorParameter = constructorParameters.get(i);
                Element parameterElement = constructorParameter.getElement();
                Accessor constructorAccessor = this.createConstructorAccessor(parameterElement, constructorParameter.getType().getTypeMirror(), string);
                constructorAccessors.put(string, constructorAccessor);
                arrayList.add(ParameterBinding.fromTypeAndName(constructorParameter.getType(), constructorAccessor.getSimpleName()));
            }
            return new ConstructorAccessor(arrayList, constructorAccessors);
        }

        private Accessor createConstructorAccessor(Element element, TypeMirror accessedType, String parameterName) {
            String safeParameterName = Strings.getSafeVariableName(parameterName, this.existingVariableNames);
            this.existingVariableNames.add(safeParameterName);
            return new ParameterElementAccessor(element, accessedType, safeParameterName);
        }

        private boolean hasDefaultAnnotationFromAnyPackage(Element element) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Default")) continue;
                return true;
            }
            return false;
        }

        private List<String> getArrayValues(AnnotationValue av) {
            if (av.getValue() instanceof List) {
                ArrayList<String> result = new ArrayList<String>();
                for (AnnotationValue v : this.getValueAsList(av)) {
                    Object value = v.getValue();
                    if (value instanceof String) {
                        result.add((String)value);
                        continue;
                    }
                    return null;
                }
                return result;
            }
            return null;
        }

        private List<AnnotationValue> getValueAsList(AnnotationValue av) {
            return (List)av.getValue();
        }

        private boolean handleDefinedMappings(Type resultTypeToMap) {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            if (this.mappingReferences.hasNestedTargetReferences()) {
                errorOccurred = this.handleDefinedNestedTargetMapping(handledTargets, resultTypeToMap);
            }
            for (MappingReference mapping : this.mappingReferences.getMappingReferences()) {
                if (mapping.isValid()) {
                    String source;
                    String target = mapping.getTargetReference().getShallowestPropertyName();
                    if (!handledTargets.contains(target) && this.handleDefinedMapping(mapping, resultTypeToMap, handledTargets)) {
                        errorOccurred = true;
                    }
                    if (mapping.getSourceReference() == null || (source = mapping.getSourceReference().getShallowestPropertyName()) == null) continue;
                    this.unprocessedSourceProperties.remove(source);
                    continue;
                }
                errorOccurred = true;
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
                this.unprocessedConstructorProperties.remove(handledTarget);
                this.unprocessedDefinedTargets.remove(handledTarget);
            }
            return errorOccurred;
        }

        private boolean handleDefinedNestedTargetMapping(Set<String> handledTargets, Type resultTypeToMap) {
            NestedTargetPropertyMappingHolder holder = new NestedTargetPropertyMappingHolder.Builder().mappingContext(this.ctx).method(this.method).targetPropertiesWriteAccessors(this.unprocessedTargetProperties).targetPropertyType(resultTypeToMap).mappingReferences(this.mappingReferences).existingVariableNames(this.existingVariableNames).build();
            this.unprocessedSourceParameters.removeAll(holder.getProcessedSourceParameters());
            this.propertyMappings.addAll(holder.getPropertyMappings());
            handledTargets.addAll(holder.getHandledTargets());
            for (Map.Entry<String, Set<MappingReference>> entry : holder.getUnprocessedDefinedTarget().entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                this.unprocessedDefinedTargets.put(entry.getKey(), entry.getValue());
            }
            return holder.hasErrorOccurred();
        }

        private boolean handleDefinedMapping(MappingReference mappingRef, Type resultTypeToMap, Set<String> handledTargets) {
            boolean errorOccured = false;
            PropertyMapping propertyMapping = null;
            TargetReference targetRef = mappingRef.getTargetReference();
            MappingOptions mapping = mappingRef.getMapping();
            for (String dependency : mapping.getDependsOn()) {
                if (this.targetProperties.contains(dependency)) continue;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                errorOccured = true;
            }
            String targetPropertyName = Collections.first(targetRef.getPropertyEntries());
            if (this.unprocessedDefinedTargets.containsKey(targetPropertyName)) {
                return false;
            }
            Accessor targetWriteAccessor = this.unprocessedTargetProperties.get(targetPropertyName);
            ReadAccessor targetReadAccessor = resultTypeToMap.getReadAccessor(targetPropertyName);
            if (targetWriteAccessor == null) {
                if (targetReadAccessor == null) {
                    Object[] args;
                    Message msg;
                    MappingOptions.InheritContext inheritContext = mapping.getInheritContext();
                    if (inheritContext != null) {
                        if (inheritContext.isForwarded() && inheritContext.getTemplateMethod().isUpdateMethod() != this.method.isUpdateMethod()) {
                            return false;
                        }
                        if (inheritContext.isReversed()) {
                            return false;
                        }
                    }
                    Set<String> readAccessors = resultTypeToMap.getPropertyReadAccessors().keySet();
                    String mostSimilarProperty = Strings.getMostSimilarWord(targetPropertyName, readAccessors);
                    if (targetRef.getPathProperties().isEmpty()) {
                        msg = Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RESULTTYPE;
                        args = new String[]{targetPropertyName, resultTypeToMap.describe(), mostSimilarProperty};
                    } else {
                        ArrayList<String> pathProperties = new ArrayList<String>(targetRef.getPathProperties());
                        pathProperties.add(mostSimilarProperty);
                        msg = Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_TYPE;
                        args = new String[]{targetPropertyName, resultTypeToMap.describe(), mapping.getTargetName(), Strings.join(pathProperties, ".")};
                    }
                    this.ctx.getMessager().printMessage(mapping.getElement(), mapping.getMirror(), mapping.getTargetAnnotationValue(), msg, args);
                    return true;
                }
                if (mapping.getInheritContext() != null && mapping.getInheritContext().isReversed()) {
                    return false;
                }
                if (!mapping.isIgnored()) {
                    Object[] args;
                    Message msg;
                    if (Objects.equals(targetPropertyName, mapping.getTargetName())) {
                        msg = Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_RESULTTYPE;
                        args = new Object[]{mapping.getTargetName(), resultTypeToMap.describe()};
                    } else {
                        msg = Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_TYPE;
                        args = new Object[]{targetPropertyName, resultTypeToMap.describe(), mapping.getTargetName()};
                    }
                    this.ctx.getMessager().printMessage(mapping.getElement(), mapping.getMirror(), mapping.getTargetAnnotationValue(), msg, args);
                    return true;
                }
            }
            if (mapping.isIgnored()) {
                if (targetWriteAccessor != null && targetWriteAccessor.getAccessorType() == AccessorType.PARAMETER) {
                    Type accessedType = this.ctx.getTypeFactory().getType(targetWriteAccessor.getAccessedType());
                    propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(accessedType.getNull()).existingVariableNames((Set)this.existingVariableNames)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).dependsOn((Set)mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                }
                handledTargets.add(targetPropertyName);
            } else if (mapping.getConstant() != null) {
                propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression(mapping.getConstant()).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).formattingParameters(mapping.getFormattingParameters()).selectionParameters(mapping.getSelectionParameters()).options(mapping).existingVariableNames((Set)this.existingVariableNames)).dependsOn((Set)mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(targetPropertyName);
            } else if (mapping.getJavaExpression() != null) {
                propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames((Set)this.existingVariableNames)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).dependsOn((Set)mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(targetPropertyName);
            } else {
                SourceReference sourceRef = mappingRef.getSourceReference();
                if (sourceRef == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        SourceReference matchingSourceRef = this.getSourceRefByTargetName(sourceParameter, targetPropertyName);
                        if (matchingSourceRef == null) continue;
                        if (sourceRef != null) {
                            errorOccured = true;
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mappingRef.getMapping().getMirror(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                            break;
                        }
                        sourceRef = matchingSourceRef;
                    }
                }
                if (sourceRef == null) {
                    sourceRef = this.method.getSourceParameters().stream().filter(p -> targetPropertyName.equals(p.getName())).findAny().map(p -> new SourceReference.BuilderFromProperty().sourceParameter((Parameter)p).name(targetPropertyName).build()).orElse(null);
                }
                if (sourceRef != null) {
                    if (sourceRef.isValid()) {
                        propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetPropertyName, targetReadAccessor, targetWriteAccessor)).sourcePropertyName(mapping.getSourceName())).sourceReference(sourceRef).selectionParameters(mapping.getSelectionParameters()).formattingParameters(mapping.getFormattingParameters()).existingVariableNames((Set)this.existingVariableNames)).dependsOn((Set)mapping.getDependsOn())).defaultValue(mapping.getDefaultValue()).defaultJavaExpression(mapping.getDefaultJavaExpression()).conditionJavaExpression(mapping.getConditionJavaExpression()).mirror(mapping.getMirror())).options(mapping).build();
                        handledTargets.add(targetPropertyName);
                        this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                        this.unprocessedSourceProperties.remove(sourceRef.getShallowestPropertyName());
                    } else {
                        errorOccured = true;
                    }
                } else {
                    errorOccured = true;
                    if (this.method.getSourceParameters().size() == 1) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getTargetAnnotationValue(), Message.PROPERTYMAPPING_CANNOT_DETERMINE_SOURCE_PROPERTY_FROM_TARGET, this.method.getSourceParameters().get(0).getName(), targetPropertyName);
                    } else {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getTargetAnnotationValue(), Message.PROPERTYMAPPING_CANNOT_DETERMINE_SOURCE_PARAMETER_FROM_TARGET, targetPropertyName);
                    }
                }
            }
            if (propertyMapping != null) {
                this.propertyMappings.add(propertyMapping);
            }
            return errorOccured;
        }

        private void applyTargetThisMapping() {
            HashSet handledTargetProperties = new HashSet();
            for (MappingReference targetThis : this.mappingReferences.getTargetThisReferences()) {
                List<SourceReference> sourceRefs = targetThis.getSourceReference().push(this.ctx.getTypeFactory(), this.ctx.getMessager(), this.method).stream().filter(sr -> this.unprocessedTargetProperties.containsKey(sr.getDeepestPropertyName()) || handledTargetProperties.contains(sr.getDeepestPropertyName())).collect(Collectors.toList());
                this.applyPropertyNameBasedMapping(sourceRefs);
                handledTargetProperties.addAll(sourceRefs.stream().map(AbstractReference::getDeepestPropertyName).collect(Collectors.toList()));
            }
        }

        private void applyPropertyNameBasedMapping() {
            ArrayList<SourceReference> sourceReferences = new ArrayList<SourceReference>();
            for (String targetPropertyName : this.unprocessedTargetProperties.keySet()) {
                for (Parameter sourceParameter : this.method.getSourceParameters()) {
                    SourceReference sourceRef = this.getSourceRefByTargetName(sourceParameter, targetPropertyName);
                    if (sourceRef == null) continue;
                    sourceReferences.add(sourceRef);
                }
            }
            this.applyPropertyNameBasedMapping(sourceReferences);
        }

        private void applyPropertyNameBasedMapping(List<SourceReference> sourceReferences) {
            for (SourceReference sourceRef : sourceReferences) {
                String targetPropertyName = sourceRef.getDeepestPropertyName();
                Accessor targetPropertyWriteAccessor = this.unprocessedTargetProperties.remove(targetPropertyName);
                this.unprocessedConstructorProperties.remove(targetPropertyName);
                if (targetPropertyWriteAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                    continue;
                }
                ReadAccessor targetPropertyReadAccessor = this.method.getResultType().getReadAccessor(targetPropertyName);
                MappingReferences mappingRefs = this.extractMappingReferences(targetPropertyName, false);
                PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetPropertyName, targetPropertyReadAccessor, targetPropertyWriteAccessor)).sourceReference(sourceRef).existingVariableNames((Set)this.existingVariableNames)).forgeMethodWithMappingReferences(mappingRefs).options(this.method.getOptions().getBeanMapping()).build();
                this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                if (propertyMapping != null) {
                    this.propertyMappings.add(propertyMapping);
                }
                this.unprocessedDefinedTargets.remove(targetPropertyName);
                this.unprocessedSourceProperties.remove(targetPropertyName);
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    ReadAccessor targetPropertyReadAccessor = this.method.getResultType().getReadAccessor(targetProperty.getKey());
                    MappingReferences mappingRefs = this.extractMappingReferences(targetProperty.getKey(), false);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).target(targetProperty.getKey(), targetPropertyReadAccessor, targetProperty.getValue())).sourceReference(sourceRef).existingVariableNames((Set)this.existingVariableNames)).forgeMethodWithMappingReferences(mappingRefs).options(this.method.getOptions().getBeanMapping()).build();
                    this.propertyMappings.add(propertyMapping);
                    targetPropertyEntriesIterator.remove();
                    sourceParameters.remove();
                    this.unprocessedDefinedTargets.remove(targetProperty.getKey());
                    this.unprocessedSourceProperties.remove(targetProperty.getKey());
                    if (!sourceParameter.getType().isPrimitive() && !sourceParameter.getType().isArrayType()) {
                        Map<String, ReadAccessor> readAccessors = sourceParameter.getType().getPropertyReadAccessors();
                        for (String sourceProperty : readAccessors.keySet()) {
                            this.unprocessedSourceProperties.remove(sourceProperty);
                        }
                    }
                    this.unprocessedConstructorProperties.remove(targetProperty.getKey());
                }
            }
        }

        private SourceReference getSourceRefByTargetName(Parameter sourceParameter, String targetPropertyName) {
            SourceReference sourceRef = null;
            if (sourceParameter.getType().isPrimitive() || sourceParameter.getType().isArrayType()) {
                return sourceRef;
            }
            ReadAccessor sourceReadAccessor = sourceParameter.getType().getReadAccessor(targetPropertyName);
            if (sourceReadAccessor != null) {
                PresenceCheckAccessor sourcePresenceChecker = sourceParameter.getType().getPresenceChecker(targetPropertyName);
                DeclaredType declaredSourceType = (DeclaredType)sourceParameter.getType().getTypeMirror();
                Type returnType = this.ctx.getTypeFactory().getReturnType(declaredSourceType, sourceReadAccessor);
                sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(returnType).readAccessor(sourceReadAccessor).presenceChecker(sourcePresenceChecker).name(targetPropertyName).build();
            }
            return sourceRef;
        }

        private MappingReferences extractMappingReferences(String targetProperty, boolean restrictToDefinedMappings) {
            if (this.unprocessedDefinedTargets.containsKey(targetProperty)) {
                Set<MappingReference> mappings = this.unprocessedDefinedTargets.get(targetProperty);
                return new MappingReferences(mappings, restrictToDefinedMappings);
            }
            return null;
        }

        private ReportingPolicyGem getUnmappedTargetPolicy() {
            if (this.mappingReferences.isForForgedMethods()) {
                return ReportingPolicyGem.IGNORE;
            }
            if (this.method.getOptions().getBeanMapping() != null) {
                return this.method.getOptions().getBeanMapping().unmappedTargetPolicy();
            }
            return this.method.getOptions().getMapper().unmappedTargetPolicy();
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicyGem unmappedTargetPolicy = this.getUnmappedTargetPolicy();
            if (this.method instanceof ForgedMethod && this.targetProperties.isEmpty()) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (forgedMethod.getHistory() == null) {
                    Type sourceType = this.method.getParameters().get(0).getType();
                    Type targetType = this.method.getReturnType();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_NOT_FOUND, sourceType.describe(), targetType.describe(), targetType.describe(), sourceType.describe());
                } else {
                    ForgedMethodHistory history = forgedMethod.getHistory();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_WITH_HISTORY_NOT_FOUND, history.createSourcePropertyErrorMessage(), history.getTargetType().describe(), history.createTargetPropertyName(), history.getTargetType().describe(), history.getSourceType().describe());
                }
            } else if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                if (!(this.method instanceof ForgedMethod)) {
                    Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                    Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", "))};
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
                } else if (!this.ctx.isErroneous()) {
                    Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_WARNING;
                    String sourceErrorMessage = this.method.getParameters().get(0).getType().describe();
                    String targetErrorMessage = this.method.getReturnType().describe();
                    if (((ForgedMethod)this.method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)this.method).getHistory();
                        sourceErrorMessage = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = MessageFormat.format("\"{0} {1}\"", history.getTargetType().describe(), history.createTargetPropertyName());
                    }
                    Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", ")), sourceErrorMessage, targetErrorMessage};
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
                }
            }
        }

        private ReportingPolicyGem getUnmappedSourcePolicy() {
            if (this.mappingReferences.isForForgedMethods()) {
                return ReportingPolicyGem.IGNORE;
            }
            if (this.method.getOptions().getBeanMapping().isignoreByDefault()) {
                return ReportingPolicyGem.IGNORE;
            }
            return this.method.getOptions().getMapper().unmappedSourcePolicy();
        }

        private void reportErrorForUnmappedSourcePropertiesIfRequired() {
            ReportingPolicyGem unmappedSourcePolicy = this.getUnmappedSourcePolicy();
            if (!this.unprocessedSourceProperties.isEmpty() && unmappedSourcePolicy.requiresReport()) {
                Message msg = unmappedSourcePolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_SOURCES_ERROR : Message.BEANMAPPING_UNMAPPED_SOURCES_WARNING;
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedSourceProperties.size(), Strings.join(this.unprocessedSourceProperties.keySet(), ", "))};
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
            }
        }

        private void reportErrorForMissingIgnoredSourceProperties() {
            if (!this.missingIgnoredSourceProperties.isEmpty()) {
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.missingIgnoredSourceProperties.size(), Strings.join(this.missingIgnoredSourceProperties, ", "))};
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_MISSING_IGNORED_SOURCES_ERROR, args);
            }
        }

        private void reportErrorForUnusedSourceParameters() {
            for (Parameter sourceParameter : this.unprocessedSourceParameters) {
                List<Type> typeParameters;
                Type parameterType = sourceParameter.getType();
                if (!parameterType.isMapType() || (typeParameters = parameterType.getTypeParameters()).size() == 2 && typeParameters.get(0).isString()) continue;
                Message message = typeParameters.isEmpty() ? Message.MAPTOBEANMAPPING_RAW_MAP : Message.MAPTOBEANMAPPING_WRONG_KEY_TYPE;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), message, sourceParameter.getName(), String.format("Map<%s,%s>", !typeParameters.isEmpty() ? typeParameters.get(0).describe() : "", typeParameters.size() > 1 ? typeParameters.get(1).describe() : ""));
            }
        }
    }
}

