/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.util.PrepareResult;

public final class ClientParser
implements PrepareResult {
    private final String sql;
    private final byte[] query;
    private final List<Integer> paramPositions;
    private final int paramCount;
    private final boolean isInsert;
    private final boolean isInsertDuplicate;

    private ClientParser(String sql, byte[] query, List<Integer> paramPositions, boolean isInsert, boolean isInsertDuplicate) {
        this.sql = sql;
        this.query = query;
        this.paramPositions = paramPositions;
        this.paramCount = paramPositions.size();
        this.isInsert = isInsert;
        this.isInsertDuplicate = isInsertDuplicate;
    }

    public static ClientParser parameterParts(String queryString, boolean noBackslashEscapes) {
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        boolean isInsert = false;
        boolean isInsertDupplicate = false;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            byte car = query[i];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state == LexState.SlashStarComment && lastChar == 42) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 73: 
                case 105: {
                    if (state != LexState.Normal || isInsert || i + 6 >= queryLength || query[i + 1] != 110 && query[i + 1] != 78 || query[i + 2] != 115 && query[i + 2] != 83 || query[i + 3] != 101 && query[i + 3] != 69 || query[i + 4] != 114 && query[i + 4] != 82 || query[i + 5] != 116 && query[i + 5] != 84 || i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1 || query[i + 6] > 32 && "();><=-+,".indexOf(query[i + 6]) == -1) break;
                    i += 5;
                    isInsert = true;
                    break;
                }
                case 68: 
                case 100: {
                    if (!isInsert || state != LexState.Normal || i + 9 >= queryLength || query[i + 1] != 117 && query[i + 1] != 85 || query[i + 2] != 112 && query[i + 2] != 80 || query[i + 3] != 108 && query[i + 3] != 76 || query[i + 4] != 105 && query[i + 4] != 73 || query[i + 5] != 99 && query[i + 5] != 67 || query[i + 6] != 97 && query[i + 6] != 65 || query[i + 7] != 116 && query[i + 7] != 84 || query[i + 8] != 101 && query[i + 8] != 69 || i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1 || query[i + 9] > 32 && "();><=-+,".indexOf(query[i + 9]) == -1) break;
                    i += 9;
                    isInsertDupplicate = true;
                    break;
                }
                case 92: {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i);
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        return new ClientParser(queryString, query, paramPositions, isInsert, isInsertDupplicate);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public byte[] getQuery() {
        return this.query;
    }

    public List<Integer> getParamPositions() {
        return this.paramPositions;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public boolean isInsert() {
        return this.isInsert;
    }

    public boolean isInsertDuplicate() {
        return this.isInsertDuplicate;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

