/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbCommonStatement;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbResult;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.message.client.QueryWithParametersPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.BindEncodedValue;
import org.mariadb.r2dbc.util.Binding;
import org.mariadb.r2dbc.util.ClientPrepareResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

final class MariadbClientParameterizedQueryStatement
extends MariadbCommonStatement {
    private final ClientPrepareResult prepareResult;

    MariadbClientParameterizedQueryStatement(Client client, String sql, MariadbConnectionConfiguration configuration) {
        super(client, sql, configuration, Protocol.TEXT);
        this.prepareResult = ClientPrepareResult.parameterParts(this.initialSql, this.client.noBackslashEscapes());
        this.expectedSize = this.prepareResult.getParamCount();
    }

    @Override
    protected int getColumnIndex(String name) {
        Assert.requireNonNull(name, "identifier cannot be null");
        for (int i = 0; i < this.prepareResult.getParamNameList().size(); ++i) {
            if (!name.equals(this.prepareResult.getParamNameList().get(i))) continue;
            return i;
        }
        if (this.prepareResult.getParamCount() <= 0) {
            throw new IndexOutOfBoundsException(String.format("Binding parameters is not supported for the statement '%s'", this.initialSql));
        }
        throw new NoSuchElementException(String.format("No parameter with name '%s' found (possible values %s)", name, this.prepareResult.getParamNameList().toString()));
    }

    @Override
    public Flux<MariadbResult> execute() {
        ExceptionFactory factory;
        String sql;
        if (this.generatedColumns == null || !this.client.getVersion().supportReturning()) {
            sql = this.initialSql;
            factory = this.factory;
        } else {
            sql = MariadbClientParameterizedQueryStatement.augment(this.initialSql, this.generatedColumns);
            factory = ExceptionFactory.withSql(sql);
        }
        if (this.getExpectedSize() != 0) {
            if (this.bindings.size() == 0) {
                throw new IllegalStateException("No parameters have been set");
            }
            this.bindings.forEach(b -> b.validate(this.getExpectedSize()));
            return Flux.defer(() -> {
                if (this.bindings.size() == 1) {
                    Binding binding = (Binding)this.bindings.pollFirst();
                    Flux messages = MariadbClientParameterizedQueryStatement.bindingParameterResults(binding, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new QueryWithParametersPacket(this.prepareResult, (List<BindEncodedValue>)values, this.client.getVersion().supportReturning() ? this.generatedColumns : null), false));
                    return MariadbClientParameterizedQueryStatement.toResult(Protocol.TEXT, this.client, (Flux<ServerMessage>)messages, factory, null, this.generatedColumns, this.configuration);
                }
                Iterator iterator = this.bindings.iterator();
                Sinks.Many bindingSink = Sinks.many().unicast().onBackpressureBuffer();
                AtomicBoolean canceled = new AtomicBoolean();
                return bindingSink.asFlux().map(it -> {
                    Flux messages = MariadbClientParameterizedQueryStatement.bindingParameterResults(it, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new QueryWithParametersPacket(this.prepareResult, (List<BindEncodedValue>)values, this.client.getVersion().supportReturning() ? this.generatedColumns : null), false)).doOnComplete(() -> MariadbClientParameterizedQueryStatement.tryNextBinding(iterator, (Sinks.Many<Binding>)bindingSink, canceled));
                    return MariadbClientParameterizedQueryStatement.toResult(Protocol.TEXT, this.client, (Flux<ServerMessage>)messages, factory, null, this.generatedColumns, this.configuration);
                }).flatMap(mariadbResultFlux -> mariadbResultFlux).doOnCancel(() -> this.clearBindings(iterator, canceled)).doOnError(e -> this.clearBindings(iterator, canceled)).doOnSubscribe(it -> bindingSink.emitNext((Object)((Binding)iterator.next()), Sinks.EmitFailureHandler.FAIL_FAST));
            });
        }
        return Flux.defer(() -> {
            Flux<ServerMessage> messages = this.client.sendCommand(new QueryPacket(sql), DecoderState.QUERY_RESPONSE, sql, false);
            return MariadbClientParameterizedQueryStatement.toResult(Protocol.TEXT, this.client, messages, factory, null, this.generatedColumns, this.configuration);
        });
    }

    @Override
    public MariadbClientParameterizedQueryStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (!this.client.getVersion().supportReturning() && columns.length > 1) {
            throw new IllegalArgumentException("returnGeneratedValues can have only one column before MariaDB 10.5.1");
        }
        this.prepareResult.validateAddingReturning();
        this.generatedColumns = columns;
        return this;
    }

    public String toString() {
        return "MariadbClientParameterizedQueryStatement{client=" + this.client + ", sql='" + this.initialSql + '\'' + ", prepareResult=" + this.prepareResult + ", bindings=" + Arrays.toString(this.bindings.toArray()) + ", configuration=" + this.configuration + ", generatedColumns=" + Arrays.toString(this.generatedColumns) + '}';
    }
}

