/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import java.util.function.Function;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.HaMode;
import org.mariadb.r2dbc.MariadbBatch;
import org.mariadb.r2dbc.MariadbClientParameterizedQueryStatement;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbConnectionMetadata;
import org.mariadb.r2dbc.MariadbServerParameterizedQueryStatement;
import org.mariadb.r2dbc.api.MariadbStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.client.ChangeSchemaPacket;
import org.mariadb.r2dbc.message.client.PingPacket;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.PrepareCache;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class MariadbConnection
implements org.mariadb.r2dbc.api.MariadbConnection {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private final Client client;
    private final MariadbConnectionConfiguration configuration;
    private volatile IsolationLevel sessionIsolationLevel;
    private volatile IsolationLevel isolationLevel;
    private volatile String database;

    public MariadbConnection(Client client, IsolationLevel isolationLevel, MariadbConnectionConfiguration configuration) {
        this.client = Assert.requireNonNull(client, "client must not be null");
        this.sessionIsolationLevel = Assert.requireNonNull(isolationLevel, "isolationLevel must not be null");
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
        this.database = configuration.getDatabase();
    }

    @Override
    public Mono<Void> beginTransaction() {
        return this.client.beginTransaction();
    }

    @Override
    public Mono<Void> beginTransaction(TransactionDefinition definition) {
        Mono request = Mono.empty();
        IsolationLevel isoLevel = (IsolationLevel)definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
        if (isoLevel != null && !isoLevel.equals(this.getTransactionIsolationLevel())) {
            String sql = String.format("SET TRANSACTION ISOLATION LEVEL %s", isoLevel.asSql());
            ExceptionFactory exceptionFactory = ExceptionFactory.withSql(sql);
            request = this.client.sendCommand(new QueryPacket(sql), true).handle(exceptionFactory::handleErrorResponse).then().doOnSuccess(ignore -> {
                this.isolationLevel = isoLevel;
            });
        }
        return request.then(this.client.beginTransaction(definition));
    }

    @Override
    public Mono<Void> close() {
        return this.client.close().then(Mono.empty());
    }

    @Override
    public Mono<Void> commitTransaction() {
        return this.client.commitTransaction().then().doOnSuccess(i -> {
            this.isolationLevel = null;
        });
    }

    @Override
    public MariadbBatch createBatch() {
        return new MariadbBatch(this.client, this.configuration);
    }

    @Override
    public Mono<Void> createSavepoint(String name) {
        Assert.requireNonNull(name, "name must not be null");
        Mono<Void> needsBegin = this.isAutoCommit() ? this.client.beginTransaction() : Mono.empty();
        String cmd = String.format("SAVEPOINT `%s`", name.replace("`", "``"));
        return needsBegin.then(this.client.sendCommand(new QueryPacket(cmd), true).handle(ExceptionFactory.withSql(cmd)::handleErrorResponse).then());
    }

    @Override
    public MariadbStatement createStatement(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if (sql.trim().isEmpty()) {
            throw new IllegalArgumentException("Statement cannot be empty.");
        }
        if (this.configuration.useServerPrepStmts() || sql.contains("call")) {
            return new MariadbServerParameterizedQueryStatement(this.client, sql, this.configuration);
        }
        return new MariadbClientParameterizedQueryStatement(this.client, sql, this.configuration);
    }

    @Override
    public MariadbConnectionMetadata getMetadata() {
        return new MariadbConnectionMetadata(this.client.getVersion());
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        if (this.isolationLevel != null) {
            return this.isolationLevel;
        }
        if ((this.client.getContext().getClientCapabilities() | 0x800000L) > 0L && this.client.getContext().getIsolationLevel() != null) {
            return this.client.getContext().getIsolationLevel();
        }
        return this.sessionIsolationLevel;
    }

    @Override
    public boolean isAutoCommit() {
        return this.client.isAutoCommit() && !this.client.isInTransaction();
    }

    @Override
    public Mono<Void> releaseSavepoint(String name) {
        Assert.requireNonNull(name, "name must not be null");
        String cmd = String.format("RELEASE SAVEPOINT `%s`", name.replace("`", "``"));
        return this.client.sendCommand(new QueryPacket(cmd), true).handle(ExceptionFactory.withSql(cmd)::handleErrorResponse).then();
    }

    @Override
    public long getThreadId() {
        return this.client.getThreadId();
    }

    @Override
    public boolean isInTransaction() {
        return (this.client.getContext().getServerStatus() & 1) > 0;
    }

    @Override
    public boolean isInReadOnlyTransaction() {
        return (this.client.getContext().getServerStatus() & 0x2000) > 0;
    }

    @Override
    public String getHost() {
        return this.client.getHostAddress() != null ? this.client.getHostAddress().getHost() : null;
    }

    @Override
    public int getPort() {
        return this.client.getHostAddress() != null ? this.client.getHostAddress().getPort() : 3306;
    }

    @Override
    public Mono<Void> rollbackTransaction() {
        return this.client.rollbackTransaction().then().doOnSuccess(i -> {
            this.isolationLevel = null;
        });
    }

    @Override
    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        Assert.requireNonNull(name, "name must not be null");
        return this.client.rollbackTransactionToSavepoint(name);
    }

    @Override
    public Mono<Void> setAutoCommit(boolean autoCommit) {
        return this.client.setAutoCommit(autoCommit).then().doOnSuccess(i -> {
            this.isolationLevel = autoCommit ? null : this.isolationLevel;
        });
    }

    @Override
    public Mono<Void> setLockWaitTimeout(Duration timeout) {
        return Mono.empty();
    }

    @Override
    public Mono<Void> setStatementTimeout(Duration timeout) {
        boolean serverSupportTimeout;
        Assert.requireNonNull(timeout, "timeout must not be null");
        boolean bl = serverSupportTimeout = this.client.getVersion().isMariaDBServer() && this.client.getVersion().versionGreaterOrEqual(10, 1, 1) || !this.client.getVersion().isMariaDBServer() && this.client.getVersion().versionGreaterOrEqual(5, 7, 4);
        if (!serverSupportTimeout) {
            return Mono.error((Throwable)ExceptionFactory.createException("query timeout not supported by server. (required MariaDB 10.1.1+ | MySQL 5.7.4+)", "HY000", -1, "SET max_statement_time"));
        }
        long msValue = timeout.toMillis();
        String sql = this.client.getVersion().isMariaDBServer() ? String.format("SET max_statement_time=%s", (double)msValue / 1000.0) : String.format("SET SESSION MAX_EXECUTION_TIME=%s", msValue);
        ExceptionFactory exceptionFactory = ExceptionFactory.withSql(sql);
        return this.client.sendCommand(new QueryPacket(sql), true).handle(exceptionFactory::handleErrorResponse).then();
    }

    @Override
    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        Assert.requireNonNull(isolationLevel, "isolationLevel must not be null");
        if ((this.client.getContext().getClientCapabilities() | 0x800000L) > 0L && this.client.getContext().getIsolationLevel() != null && this.client.getContext().getIsolationLevel().equals(isolationLevel)) {
            return Mono.empty();
        }
        String sql = String.format("SET SESSION TRANSACTION ISOLATION LEVEL %s", isolationLevel.asSql());
        ExceptionFactory exceptionFactory = ExceptionFactory.withSql(sql);
        IsolationLevel newIsolation = isolationLevel;
        return this.client.sendCommand(new QueryPacket(sql), true).handle(exceptionFactory::handleErrorResponse).then().doOnSuccess(ignore -> {
            this.sessionIsolationLevel = newIsolation;
        });
    }

    public String toString() {
        return "MariadbConnection{client=" + this.client + ", isolationLevel=" + ((this.client.getContext().getClientCapabilities() | 0x800000L) > 0L ? this.client.getContext().getIsolationLevel() : this.sessionIsolationLevel) + '}';
    }

    @Override
    public Mono<Boolean> validate(ValidationDepth depth) {
        if (this.client.isCloseRequested()) {
            return Mono.just((Object)false);
        }
        if (depth == ValidationDepth.LOCAL) {
            return Mono.just((Object)this.client.isConnected());
        }
        return Mono.create(sink -> {
            if (HaMode.NONE.equals((Object)this.configuration.getHaMode()) && !this.client.isConnected()) {
                sink.success((Object)false);
                return;
            }
            this.client.sendCommand(new PingPacket(), true).windowUntil(it -> it.ending()).flatMap(Function.identity()).subscribe(msg -> sink.success((Object)true), err -> {
                this.logger.debug("Ping error", err);
                sink.success((Object)false);
            });
        });
    }

    @Override
    public String getDatabase() {
        if ((this.client.getContext().getClientCapabilities() | 0x800000L) > 0L) {
            return this.client.getContext().getDatabase();
        }
        return this.database;
    }

    @Override
    public Mono<Void> setDatabase(String database) {
        Assert.requireNonNull(database, "database must not be null");
        if ((this.client.getContext().getClientCapabilities() | 0x800000L) > 0L && this.client.getContext().getDatabase() != null && this.client.getContext().getDatabase().equals(database)) {
            return Mono.empty();
        }
        ExceptionFactory exceptionFactory = ExceptionFactory.withSql("COM_INIT_DB");
        String newDatabase = database;
        return this.client.sendCommand(new ChangeSchemaPacket(database), true).handle(exceptionFactory::handleErrorResponse).then().doOnSuccess(ignore -> {
            this.database = newDatabase;
        });
    }

    public PrepareCache _test_prepareCache() {
        return this.client.getPrepareCache();
    }
}

