/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;

final class MariadbRowMetadata
implements RowMetadata {
    private final List<ColumnDefinitionPacket> metadataList;
    private volatile Collection<String> columnNames;

    MariadbRowMetadata(List<ColumnDefinitionPacket> metadataList) {
        this.metadataList = metadataList;
    }

    public ColumnDefinitionPacket getColumnMetadata(int index) {
        if (index < 0 || index >= this.metadataList.size()) {
            throw new IndexOutOfBoundsException(String.format("Column index %d is not in permit range[0,%s]", index, this.metadataList.size() - 1));
        }
        return this.metadataList.get(index);
    }

    public ColumnDefinitionPacket getColumnMetadata(String name) {
        return this.metadataList.get(this.getColumn(name));
    }

    private int getColumn(String name) {
        Assert.requireNonNull(name, "name must not be null");
        for (int i = 0; i < this.metadataList.size(); ++i) {
            if (!this.metadataList.get(i).getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new NoSuchElementException(String.format("Column name '%s' does not exist in column names %s", name, this.getColumnNames()));
    }

    public List<ColumnDefinitionPacket> getColumnMetadatas() {
        return Collections.unmodifiableList(this.metadataList);
    }

    @Deprecated
    public Collection<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        return Collections.unmodifiableCollection(this.columnNames);
    }

    private Collection<String> getColumnNames(List<ColumnDefinitionPacket> columnMetadatas) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDefinitionPacket columnMetadata : columnMetadatas) {
            columnNames.add(columnMetadata.getName());
        }
        return Collections.unmodifiableCollection(columnNames);
    }

    public String toString() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        StringBuilder sb = new StringBuilder("MariadbRowMetadata{");
        sb.append("columnNames=").append(this.columnNames).append("}");
        return sb.toString();
    }

    public boolean contains(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        return this.columnNames.stream().anyMatch(columnName::equalsIgnoreCase);
    }
}

