/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Queue;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.client.Exchange;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.PrepareCache;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.util.concurrent.Queues;

public class MariadbFrameDecoder
extends ByteToMessageDecoder {
    private CompositeByteBuf multipart = null;
    private final Queue<Exchange> exchangeQueue;
    private final Client client;
    private final MariadbConnectionConfiguration configuration;
    private DecoderState state = null;
    private final Queue<String> prepareSql = (Queue)Queues.small().get();
    private long clientCapabilities;
    private int stateCounter = 0;
    private boolean metaFollows = false;
    private PrepareResultPacket prepare;
    private ColumnDefinitionPacket[] prepareColumns;
    private Context context = null;

    public MariadbFrameDecoder(Queue<Exchange> exchangeQueue, Client client, MariadbConnectionConfiguration configuration) {
        this.exchangeQueue = exchangeQueue;
        this.client = client;
        this.configuration = configuration;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        while (buf.readableBytes() > 4) {
            int length = buf.getUnsignedMediumLE(buf.readerIndex());
            if (buf.readableBytes() < length + 4) {
                return;
            }
            if (length == 0xFFFFFF) {
                if (this.multipart == null) {
                    this.multipart = buf.alloc().compositeBuffer();
                }
                buf.skipBytes(4);
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                continue;
            }
            if (this.multipart != null) {
                buf.skipBytes(3);
                this.multipart.addComponent(true, 0, Unpooled.wrappedBuffer((byte[])new byte[]{buf.readByte()}));
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                out.add(this.decode((ByteBuf)this.multipart));
                this.multipart.release();
                this.multipart = null;
                continue;
            }
            buf.skipBytes(3);
            ByteBuf packet = buf.readRetainedSlice(1 + length);
            out.add(this.decode(packet));
            packet.release();
        }
    }

    private ServerMessage decode(ByteBuf packet) {
        Sequencer sequencer = new Sequencer(packet.readByte());
        Exchange exchange = this.exchangeQueue.peek();
        if (this.state == null) {
            this.state = exchange == null ? DecoderState.QUERY_RESPONSE : exchange.getInitialState();
        }
        this.state = this.state.decoder(packet.getUnsignedByte(packet.readerIndex()), packet.readableBytes());
        ServerMessage msg = this.state.decode(packet, sequencer, this);
        this.state = msg.ending() ? null : this.state.next(this);
        return msg;
    }

    public Context getContext() {
        return this.context;
    }

    public int getStateCounter() {
        return this.stateCounter;
    }

    public void setStateCounter(int counter) {
        this.stateCounter = counter;
    }

    public PrepareResultPacket getPrepare() {
        return this.prepare;
    }

    public void setPrepare(PrepareResultPacket prepare) {
        this.prepare = prepare;
        this.prepareColumns = prepare == null ? null : new ColumnDefinitionPacket[prepare.getNumColumns()];
    }

    public ColumnDefinitionPacket[] getPrepareColumns() {
        return this.prepareColumns;
    }

    public MariadbConnectionConfiguration getConf() {
        return this.configuration;
    }

    public ServerPrepareResult endPrepare() {
        ServerPrepareResult cached;
        ServerPrepareResult prepareResult = new ServerPrepareResult(this.prepare.getStatementId(), this.prepare.getNumParams(), this.prepareColumns);
        String sql = this.prepareSql.poll();
        PrepareCache prepareCache = this.client.getPrepareCache();
        if (prepareCache != null && (cached = prepareCache.put(sql, prepareResult)) != null) {
            prepareResult.decrementUse(this.client);
            prepareResult = cached;
        }
        return prepareResult;
    }

    public void decrementStateCounter() {
        --this.stateCounter;
    }

    public long getClientCapabilities() {
        return this.clientCapabilities;
    }

    public boolean addPrepare(String sql) {
        return this.prepareSql.offer(sql);
    }

    public void setContext(Context context) {
        this.context = context;
        this.clientCapabilities = this.context.getClientCapabilities();
    }

    public boolean isMetaFollows() {
        return this.metaFollows;
    }

    public void setMetaFollows(boolean metaFollows) {
        this.metaFollows = metaFollows;
    }
}

