/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import java.util.Queue;
import org.mariadb.r2dbc.message.ClientMessage;
import reactor.util.concurrent.Queues;

public class TransactionSaver {
    private final Queue<ClientMessage> messages = (Queue)Queues.get((int)Queues.SMALL_BUFFER_SIZE).get();
    private boolean dirty = false;

    public void add(ClientMessage clientMessage) {
        if (!this.messages.offer(clientMessage)) {
            this.dirty = true;
        }
    }

    public void clear() {
        ClientMessage clientMessage;
        while ((clientMessage = this.messages.poll()) != null) {
            clientMessage.releaseSave();
        }
        this.messages.clear();
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void forceDirty() {
        this.dirty = true;
    }

    public Queue<ClientMessage> getMessages() {
        return this.messages;
    }
}

