/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.mariadb.r2dbc.authentication.standard.CachingSha2PasswordFlow;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.client.NativePasswordPacket;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.BufferUtils;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Mono;

public final class HandshakeResponse
implements ClientMessage {
    private final InitialHandshakePacket initialHandshakePacket;
    private final String username;
    private final CharSequence password;
    private final String database;
    private final Map<String, String> connectionAttributes;
    private final HostAddress hostAddress;
    private final long clientCapabilities;

    public HandshakeResponse(InitialHandshakePacket initialHandshakePacket, String username, CharSequence password, String database, Map<String, String> connectionAttributes, HostAddress hostAddress, long clientCapabilities) {
        this.initialHandshakePacket = initialHandshakePacket;
        this.username = username;
        this.password = password;
        this.database = database;
        this.connectionAttributes = connectionAttributes;
        this.hostAddress = hostAddress;
        this.clientCapabilities = clientCapabilities;
    }

    public static byte decideLanguage(short serverLanguage, int majorVersion, int minorVersion) {
        if (serverLanguage == 45 || serverLanguage == 46 || serverLanguage >= 224 && serverLanguage <= 247) {
            return (byte)serverLanguage;
        }
        return (byte)(majorVersion == 5 && minorVersion <= 1 ? 33 : 224);
    }

    @Override
    public Mono<ByteBuf> encode(Context context, ByteBufAllocator allocator) {
        byte[] authData;
        String authenticationPluginType;
        byte exchangeCharset = HandshakeResponse.decideLanguage(this.initialHandshakePacket.getDefaultCollation(), this.initialHandshakePacket.getMajorServerVersion(), this.initialHandshakePacket.getMinorServerVersion());
        ByteBuf buf = allocator.buffer(4096);
        switch (authenticationPluginType = this.initialHandshakePacket.getAuthenticationPluginType()) {
            case "mysql_clear_password": {
                authData = this.password == null ? new byte[]{} : this.password.toString().getBytes(StandardCharsets.UTF_8);
                break;
            }
            case "caching_sha2_password": {
                authenticationPluginType = "caching_sha2_password";
                authData = this.password == null ? new byte[]{} : CachingSha2PasswordFlow.sha256encryptPassword(this.password, this.initialHandshakePacket.getSeed());
                break;
            }
            default: {
                authenticationPluginType = "mysql_native_password";
                authData = NativePasswordPacket.encrypt(this.password, this.initialHandshakePacket.getSeed());
            }
        }
        buf.writeIntLE((int)this.clientCapabilities);
        buf.writeIntLE(0x40000000);
        buf.writeByte((int)exchangeCharset);
        buf.writeZero(19);
        buf.writeIntLE((int)(this.clientCapabilities >> 32));
        buf.writeCharSequence((CharSequence)(this.username != null && !this.username.isEmpty() ? this.username : System.getProperty("user.name")), StandardCharsets.UTF_8);
        buf.writeZero(1);
        if ((this.initialHandshakePacket.getCapabilities() & 0x200000L) != 0L) {
            buf.writeBytes(BufferUtils.encodeLength(authData.length));
            buf.writeBytes(authData);
        } else if ((this.initialHandshakePacket.getCapabilities() & 0x8000L) != 0L) {
            buf.writeByte((int)((byte)authData.length));
            buf.writeBytes(authData);
        } else {
            buf.writeBytes(authData);
            buf.writeZero(1);
        }
        if ((this.clientCapabilities & 8L) != 0L) {
            buf.writeCharSequence((CharSequence)this.database, StandardCharsets.UTF_8);
            buf.writeZero(1);
        }
        if ((this.initialHandshakePacket.getCapabilities() & 0x80000L) != 0L) {
            buf.writeCharSequence((CharSequence)authenticationPluginType, StandardCharsets.UTF_8);
            buf.writeZero(1);
        }
        if ((this.initialHandshakePacket.getCapabilities() & 0x100000L) != 0L) {
            ByteBuf bufAttributes = allocator.buffer(2048);
            this.writeConnectAttributes(bufAttributes, this.connectionAttributes, this.hostAddress);
            buf.writeBytes(BufferUtils.encodeLength(bufAttributes.writerIndex()));
            buf.writeBytes(bufAttributes, 0, bufAttributes.writerIndex());
            bufAttributes.release();
        }
        return Mono.just((Object)buf);
    }

    @Override
    public Sequencer getSequencer() {
        return this.initialHandshakePacket.getSequencer();
    }

    private void writeConnectAttributes(ByteBuf buf, Map<String, String> connectionAttributes, HostAddress hostAddress) {
        BufferUtils.writeLengthEncode("_client_name", buf);
        BufferUtils.writeLengthEncode("mariadb", buf);
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("project.properties");){
            properties.load(inputStream);
            BufferUtils.writeLengthEncode("_client_version", buf);
            BufferUtils.writeLengthEncode(properties.getProperty("version"), buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferUtils.writeLengthEncode("_server_host", buf);
        BufferUtils.writeLengthEncode(hostAddress != null ? hostAddress.getHost() : "", buf);
        BufferUtils.writeLengthEncode("_os", buf);
        BufferUtils.writeLengthEncode(System.getProperty("os.name"), buf);
        BufferUtils.writeLengthEncode("_thread", buf);
        BufferUtils.writeLengthEncode(Long.toString(Thread.currentThread().getId()), buf);
        BufferUtils.writeLengthEncode("_java_vendor", buf);
        BufferUtils.writeLengthEncode(System.getProperty("java.vendor"), buf);
        BufferUtils.writeLengthEncode("_java_version", buf);
        BufferUtils.writeLengthEncode(System.getProperty("java.version"), buf);
        if (connectionAttributes != null && !connectionAttributes.isEmpty()) {
            connectionAttributes.forEach((key, val) -> {
                BufferUtils.writeLengthEncode(key, buf);
                BufferUtils.writeLengthEncode(val, buf);
            });
        }
    }
}

