/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.ClientParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class QueryWithParametersPacket
implements ClientMessage {
    private final ClientParser parser;
    private final BindValue[] bindValues;
    private final MessageSequence sequencer = new Sequencer(-1);
    private final String[] generatedColumns;
    private ByteBuf savedBuf = null;

    public QueryWithParametersPacket(ClientParser parser, BindValue[] bindValues, String[] generatedColumns) {
        this.parser = parser;
        this.bindValues = bindValues;
        this.generatedColumns = generatedColumns;
    }

    @Override
    public Mono<ByteBuf> encode(Context context, ByteBufAllocator byteBufAllocator) {
        if (this.savedBuf != null) {
            ByteBuf tmp = this.savedBuf;
            this.savedBuf = null;
            return Mono.just((Object)tmp);
        }
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        String additionalReturningPart = this.generatedColumns != null ? (this.generatedColumns.length == 0 ? " RETURNING *" : " RETURNING " + String.join((CharSequence)", ", this.generatedColumns)) : null;
        ByteBuf out = byteBufAllocator.ioBuffer();
        out.writeByte(3);
        if (this.parser.getParamCount() == 0) {
            out.writeBytes(this.parser.getQuery());
            if (additionalReturningPart != null) {
                out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
            }
        } else {
            boolean direct = true;
            for (int i2 = 0; i2 < this.parser.getParamCount(); ++i2) {
                BindValue param = this.bindValues[i2];
                if (param.getCodec().isDirect()) continue;
                direct = false;
                break;
            }
            if (direct) {
                int currentPos = 0;
                for (int i3 = 0; i3 < this.parser.getParamCount(); ++i3) {
                    out.writeBytes(this.parser.getQuery(), currentPos, this.parser.getParamPositions().get(i3 * 2) - currentPos);
                    currentPos = this.parser.getParamPositions().get(i3 * 2 + 1);
                    BindValue param = this.bindValues[i3];
                    if (param.getValue() == null) {
                        out.writeBytes("null".getBytes(StandardCharsets.US_ASCII));
                        continue;
                    }
                    param.encodeDirectText(out, context);
                }
                if (currentPos < this.parser.getQuery().length) {
                    out.writeBytes(this.parser.getQuery(), currentPos, this.parser.getQuery().length - currentPos);
                }
                if (additionalReturningPart != null) {
                    out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
                }
            } else {
                AtomicInteger currentPos = new AtomicInteger(0);
                return Flux.range((int)0, (int)this.parser.getParamCount()).flatMap(i -> {
                    out.writeBytes(this.parser.getQuery(), currentPos.get(), this.parser.getParamPositions().get(i * 2) - currentPos.get());
                    currentPos.set(this.parser.getParamPositions().get(i * 2 + 1));
                    BindValue param = this.bindValues[i];
                    if (param.getValue() == null) {
                        out.writeBytes("null".getBytes(StandardCharsets.US_ASCII));
                    } else if (param.getCodec().isDirect()) {
                        param.encodeDirectText(out, context);
                    } else {
                        return param.encodeText(byteBufAllocator, context).map(b -> {
                            out.writeBytes(b);
                            b.release();
                            return Mono.empty();
                        });
                    }
                    return Mono.empty();
                }).then().doOnSuccess(v -> {
                    if (currentPos.get() < this.parser.getQuery().length) {
                        out.writeBytes(this.parser.getQuery(), currentPos.get(), this.parser.getQuery().length - currentPos.get());
                    }
                    if (additionalReturningPart != null) {
                        out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
                    }
                }).then(Mono.just((Object)out));
            }
        }
        return Mono.just((Object)out);
    }

    @Override
    public void save(ByteBuf buf, int initialReaderIndex) {
        this.savedBuf = buf.readerIndex(initialReaderIndex).retain();
    }

    @Override
    public void resetSequencer() {
        this.sequencer.reset();
    }

    @Override
    public void releaseSave() {
        if (this.savedBuf != null) {
            this.savedBuf.release();
            this.savedBuf = null;
        }
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }
}

