/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import org.mariadb.r2dbc.message.AuthMoreData;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.ServerMessage;

public class AuthMoreDataPacket
implements AuthMoreData,
ServerMessage,
ReferenceCounted {
    private final MessageSequence sequencer;
    private final ByteBuf buf;

    private AuthMoreDataPacket(MessageSequence sequencer, ByteBuf buf) {
        this.sequencer = sequencer;
        this.buf = buf;
    }

    public static AuthMoreDataPacket decode(MessageSequence sequencer, ByteBuf buf, Context context) {
        buf.skipBytes(1);
        ByteBuf data = buf.readRetainedSlice(buf.readableBytes());
        return new AuthMoreDataPacket(sequencer, data);
    }

    @Override
    public int refCnt() {
        return this.buf.refCnt();
    }

    public ReferenceCounted retain() {
        this.buf.retain();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    public ReferenceCounted touch() {
        this.buf.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.buf.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.buf.release();
    }

    public boolean release(int decrement) {
        return this.buf.release();
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }

    @Override
    public ByteBuf getBuf() {
        return this.buf;
    }

    @Override
    public boolean ending() {
        return true;
    }
}

