/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.util.Arrays;
import java.util.Objects;
import org.mariadb.r2dbc.util.BindValue;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class Binding {
    private static final Logger LOGGER = Loggers.getLogger(Binding.class);
    private BindValue[] binds;
    private final int expectedSize;
    private int currentSize = 0;

    public Binding(int expectedSize) {
        this.expectedSize = expectedSize;
        this.binds = new BindValue[expectedSize == -1 ? 10 : expectedSize];
    }

    public Binding add(int index, BindValue parameter) {
        if (index >= this.expectedSize) {
            if (this.expectedSize != -1) {
                throw new IndexOutOfBoundsException(String.format("Binding index %d when only %d parameters are expected", index, this.expectedSize));
            }
            this.grow(index + 1);
        }
        if (index >= this.currentSize) {
            this.currentSize = index + 1;
        }
        this.binds[index] = parameter;
        return this;
    }

    private void grow(int minLength) {
        int currLength = this.binds.length;
        int newLength = Math.max(currLength + (currLength >> 1), minLength);
        this.binds = Arrays.copyOf(this.binds, newLength);
    }

    public void clear() {
        this.binds = new BindValue[this.expectedSize];
        this.currentSize = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding that = (Binding)o;
        return Objects.equals(this.binds, that.binds);
    }

    public int hashCode() {
        int result = Objects.hash(this.expectedSize);
        result = 31 * result + Arrays.hashCode(this.binds);
        return result;
    }

    public String toString() {
        return Arrays.toString(this.binds);
    }

    public void validate(int expectedSize) {
        for (int i = 0; i < expectedSize; ++i) {
            if (this.binds[i] != null) continue;
            throw new IllegalStateException(String.format("Parameter at position %d is not set", i));
        }
    }

    public BindValue[] getBindResultParameters(int paramNumber) {
        if (paramNumber == 0) {
            return new BindValue[0];
        }
        if (paramNumber < this.binds.length) {
            throw new IllegalStateException(String.format("No parameter specified for index %d", this.binds.length));
        }
        for (int i = 0; i < paramNumber; ++i) {
            if (this.binds[i] != null) continue;
            throw new IllegalStateException(String.format("No parameter specified for index %d", i));
        }
        if (paramNumber == this.expectedSize) {
            return this.binds;
        }
        if (paramNumber < this.expectedSize) {
            return Arrays.copyOfRange(this.binds, 0, paramNumber);
        }
        throw new IllegalStateException(String.format("No parameter specified for index %d", this.expectedSize));
    }

    public BindValue[] getBinds() {
        for (int i = 0; i < this.currentSize; ++i) {
            if (this.binds[i] != null) continue;
            throw new IllegalStateException(String.format("No parameter specified for index %d", i));
        }
        return Arrays.copyOfRange(this.binds, 0, this.currentSize);
    }
}

